/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.imageread.ImageReadDescriptor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class MultiLevelROIRaster
implements MultiLevelROI {
    private static final Logger LOGGER = Logging.getLogger(MultiLevelROIRaster.class);
    private Geometry footprint;
    private ReferencedEnvelope env;
    private MaskOverviewProvider maskOvrProvider;

    public MultiLevelROIRaster(DatasetLayout layout, MaskOverviewProvider maskOvrProvider, SimpleFeature sf) throws IOException {
        Geometry geo = (Geometry)sf.getDefaultGeometry();
        this.env = JTS.toEnvelope((Geometry)geo);
        this.footprint = JTS.toGeometry((ReferencedEnvelope)this.env);
        this.maskOvrProvider = maskOvrProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROI getTransformedROI(AffineTransform at, int imageIndex, Rectangle imgBounds, ImageReadParam params, ReadType readType) {
        MaskOverviewProvider.MaskInfo info = this.maskOvrProvider.getMaskInfo(imageIndex, imgBounds, params);
        int index = info.index;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = this.maskOvrProvider.getMaskStream(info);
            reader = info.readerSpi.createReaderInstance();
            reader.setInput(inStream, false, false);
            BufferedImage raster = null;
            if (readType.equals((Object)ReadType.DIRECT_READ)) {
                raster = reader.read(index, info.readParameters);
            } else {
                inStream.seek(0L);
                raster = ImageReadDescriptor.create((ImageInputStream)inStream, (Integer)index, (Boolean)false, (Boolean)false, (Boolean)false, null, null, (ImageReadParam)info.readParameters, (ImageReader)reader, null);
            }
            ROI rOI = MaskOverviewProvider.scaleROI(raster, imgBounds);
            return rOI;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            block24: {
                block23: {
                    if (readType != ReadType.JAI_IMAGEREAD && reader != null) {
                        try {
                            reader.dispose();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block23;
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                if (readType != ReadType.JAI_IMAGEREAD && inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block24;
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.env.isEmpty();
    }

    @Override
    public Geometry getFootprint() {
        return this.footprint;
    }
}

