/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.ExtendedImagingParameterDescriptors;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public abstract class BaseMathOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 6830028735162290160L;
    public static final Logger LOGGER = Logging.getLogger(BaseMathOperationJAI.class);
    public static final String SOURCES_NAME = "Sources";
    public static final ParameterDescriptor<Collection> SOURCES = new DefaultParameterDescriptor<Object>(Citations.IMAGEN, "Sources", Collection.class, null, null, null, null, null, true);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor) {
        super(operationDescriptor, new ImagingParameterDescriptors((RegistryElementDescriptor)BaseMathOperationJAI.getOperationDescriptor(operationDescriptor.getName()), REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor, ImagingParameterDescriptors replacements) {
        super(operationDescriptor, new ImagingParameterDescriptors(ImagingParameterDescriptors.properties((RegistryElementDescriptor)operationDescriptor), (RegistryElementDescriptor)operationDescriptor, "rendered", ImagingParameterDescriptors.DEFAULT_SOURCE_TYPE_MAP, REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(String name, OperationDescriptor operationDescriptor) {
        super(operationDescriptor, new ExtendedImagingParameterDescriptors(name, (RegistryElementDescriptor)operationDescriptor, new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    public BaseMathOperationJAI(String name) {
        super(BaseMathOperationJAI.getOperationDescriptor(name), new ImagingParameterDescriptors((RegistryElementDescriptor)BaseMathOperationJAI.getOperationDescriptor(name), new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    @Override
    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources, String[] sourceNames) throws ParameterNotFoundException, InvalidParameterValueException {
        Utilities.ensureNonNull((String)"parameters", (Object)parameters);
        Utilities.ensureNonNull((String)"sources", sources);
        Object srcCoverages = parameters.parameter(SOURCES_NAME).getValue();
        if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
            throw new InvalidParameterValueException(MessageFormat.format("Illegal value for argument \"{0}\".", "sources"), "sources", srcCoverages);
        }
        Collection sourceCoverages = (Collection)srcCoverages;
        sources.addAll(sourceCoverages);
    }

    static {
        HashSet<ParameterDescriptor<Collection>> replacedDescriptors = new HashSet<ParameterDescriptor<Collection>>();
        replacedDescriptors.add(SOURCES);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }
}

