/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.ExtendedImagingParameterDescriptors;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public abstract class BaseStatisticsOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 6830028735162290160L;
    public static final Logger LOGGER = Logging.getLogger(BaseStatisticsOperationJAI.class);
    public static final ParameterDescriptor<Double> SPATIAL_SUBSAMPLING_X = new DefaultParameterDescriptor<Object>(Citations.IMAGEN, "xPeriod", Double.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<Double> SPATIAL_SUBSAMPLING_Y = new DefaultParameterDescriptor<Object>(Citations.IMAGEN, "yPeriod", Double.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<Polygon> ROI = new DefaultParameterDescriptor<Object>(Citations.IMAGEN, "roi", Polygon.class, null, null, null, null, null, true);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public BaseStatisticsOperationJAI(OperationDescriptor operationDescriptor) {
        super(operationDescriptor, new ImagingParameterDescriptors((RegistryElementDescriptor)BaseStatisticsOperationJAI.getOperationDescriptor(operationDescriptor.getName()), REPLACED_DESCRIPTORS));
    }

    public BaseStatisticsOperationJAI(OperationDescriptor operationDescriptor, ImagingParameterDescriptors replacements) {
        super(operationDescriptor, new ImagingParameterDescriptors(ImagingParameterDescriptors.properties((RegistryElementDescriptor)operationDescriptor), (RegistryElementDescriptor)operationDescriptor, "rendered", ImagingParameterDescriptors.DEFAULT_SOURCE_TYPE_MAP, REPLACED_DESCRIPTORS));
    }

    public BaseStatisticsOperationJAI(String name, OperationDescriptor operationDescriptor) {
        super(operationDescriptor, new ExtendedImagingParameterDescriptors(name, (RegistryElementDescriptor)operationDescriptor, new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    public BaseStatisticsOperationJAI(String name) {
        super(BaseStatisticsOperationJAI.getOperationDescriptor(name), new ImagingParameterDescriptors((RegistryElementDescriptor)BaseStatisticsOperationJAI.getOperationDescriptor(name), new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    @Override
    protected ParameterBlockImageN prepareParameters(ParameterValueGroup parameters) {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockImageN block = (ParameterBlockImageN)copy.parameters;
        try {
            Polygon roiInput;
            Object o;
            LinearTransform worldToGridTransform;
            GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter(this.operation.getSourceNames()[0]).getValue());
            AffineTransform gridToWorldTransformCorrected = new AffineTransform((AffineTransform)source.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT));
            try {
                worldToGridTransform = ProjectiveTransform.create(gridToWorldTransformCorrected.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                CoverageProcessingException ce = new CoverageProcessingException(e);
                throw ce;
            }
            CoordinateReferenceSystem crs = source.getCoordinateReferenceSystem2D();
            ReferencedEnvelope envelope = source.getEnvelope2D();
            double xPeriod = parameters.parameter("xPeriod").doubleValue();
            double yPeriod = parameters.parameter("yPeriod").doubleValue();
            if (!Double.isNaN(xPeriod) && !Double.isNaN(yPeriod)) {
                ReferencedEnvelope shrinkedEnvelope = new ReferencedEnvelope(envelope.getMinX(), envelope.getMinX() + xPeriod, envelope.getMinY(), envelope.getMinY() + yPeriod, crs);
                Rectangle2D transformedEnv = CRS.transform(worldToGridTransform, (Bounds)shrinkedEnvelope).toRectangle2D();
                block.setParameter("xPeriod", (Object)((int)transformedEnv.getWidth()));
                block.setParameter("yPeriod", (Object)((int)transformedEnv.getHeight()));
            }
            if ((o = parameters.parameter("roi").getValue()) != null && o instanceof Polygon && new ReferencedEnvelope((roiInput = (Polygon)o).getEnvelopeInternal(), source.getCoordinateReferenceSystem2D()).intersects((Envelope)new ReferencedEnvelope(envelope))) {
                java.awt.Polygon shapePolygon = BaseStatisticsOperationJAI.convertPolygon(roiInput, worldToGridTransform);
                block.setParameter("roi", (Object)new ROIShape((Shape)shapePolygon));
            }
            this.handleJAIEXTParams(block, parameters);
            return block;
        }
        catch (Exception e) {
            CoverageProcessingException ce = new CoverageProcessingException(e);
            throw ce;
        }
    }

    protected static java.awt.Polygon convertPolygon(Polygon roiInput, MathTransform worldToGridTransform) throws TransformException {
        boolean isIdentity = worldToGridTransform.isIdentity();
        java.awt.Polygon retValue = new java.awt.Polygon();
        double[] coords = new double[2];
        LinearRing exteriorRing = roiInput.getExteriorRing();
        CoordinateSequence exteriorRingCS = exteriorRing.getCoordinateSequence();
        int numCoords = exteriorRingCS.size();
        for (int i = 0; i < numCoords; ++i) {
            coords[0] = exteriorRingCS.getX(i);
            coords[1] = exteriorRingCS.getY(i);
            if (!isIdentity) {
                worldToGridTransform.transform(coords, 0, coords, 0, 1);
            }
            retValue.addPoint((int)(coords[0] + 0.5), (int)(coords[1] + 0.5));
        }
        return retValue;
    }

    static {
        HashSet<Object> replacedDescriptors = new HashSet<Object>();
        replacedDescriptors.add(SPATIAL_SUBSAMPLING_X);
        replacedDescriptors.add(SPATIAL_SUBSAMPLING_Y);
        replacedDescriptors.add(ROI);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }
}

