/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Color;
import java.io.Writer;
import java.util.Locale;
import org.eclipse.imagen.EnumeratedParameter;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.KernelImageN;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.parameter.ParameterWriter;

final class CoverageParameterWriter
extends ParameterWriter {
    public CoverageParameterWriter(Writer out) {
        super(out);
    }

    @Override
    protected String formatValue(Object value) {
        if (KernelImageN.GRADIENT_MASK_SOBEL_HORIZONTAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_HORIZONTAL";
        }
        if (KernelImageN.GRADIENT_MASK_SOBEL_VERTICAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_VERTICAL";
        }
        if (value instanceof AbstractCoverage) {
            AbstractCoverage coverage = (AbstractCoverage)((Object)value);
            InternationalString name = coverage.getName();
            Locale locale = this.getLocale();
            return name != null ? name.toString(locale) : Vocabulary.getResources((Locale)locale).getString(232);
        }
        if (value instanceof Interpolation) {
            Interpolation interpolation = (Interpolation)value;
            return ImageUtilities.getInterpolationName(interpolation);
        }
        if (value instanceof EnumeratedParameter) {
            EnumeratedParameter parameter = (EnumeratedParameter)value;
            return parameter.getName();
        }
        if (value instanceof Color) {
            Color c = (Color)value;
            return "RGB[" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]";
        }
        return super.formatValue(value);
    }
}

