/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.text.MessageFormat;
import java.util.HashMap;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;

public abstract class Operation2D
extends AbstractOperation {
    private static final long serialVersionUID = 574096338873406394L;
    protected static final int PRIMARY_SOURCE_INDEX = 0;
    public static final ParameterDescriptor<GridCoverage2D> SOURCE_0;

    public Operation2D(ParameterDescriptorGroup descriptor) {
        super(descriptor);
    }

    protected void extractSources(ParameterValueGroup parameters, String[] sourceNames, GridCoverage2D[] sources) throws ParameterNotFoundException, InvalidParameterValueException {
        Utilities.ensureNonNull((String)"parameters", (Object)parameters);
        Utilities.ensureNonNull((String)"sourceNames", (Object)sourceNames);
        Utilities.ensureNonNull((String)"sources", (Object)sources);
        if (sources.length != sourceNames.length) {
            throw new IllegalArgumentException("Mismatched array length.");
        }
        for (int i = 0; i < sourceNames.length; ++i) {
            GridCoverage2D source;
            Object candidate = parameters.parameter(sourceNames[i]).getValue();
            if (candidate == null) continue;
            if (!(candidate instanceof GridCoverage2D)) {
                throw new InvalidParameterValueException(MessageFormat.format("Class '{0}' is illegal. It must be '{1}' or a derivated class.", Classes.getClass((Object)candidate), GridCoverage2D.class), sourceNames[i], candidate);
            }
            sources[i] = source = (GridCoverage2D)((Object)candidate);
        }
    }

    protected static GridCoverageFactory getFactory(Hints hints) {
        return CoverageFactoryFinder.getGridCoverageFactory(hints);
    }

    static {
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
        properties.put("name", new NamedIdentifier(Citations.OGC, "Source"));
        properties.put("alias", new NamedIdentifier(Citations.IMAGEN, "source0"));
        SOURCE_0 = new DefaultParameterDescriptor<Object>(properties, GridCoverage2D.class, null, null, null, null, null, true);
    }
}

