/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class Add
extends BaseMathOperationJAI {
    private static final String ALGEBRIC = "algebric";
    private static final String ADD = "Add";
    private static final long serialVersionUID = -4029879745691129215L;

    public Add() {
        super(ADD, Add.getOperationDescriptor(ALGEBRIC));
    }

    @Override
    public String getName() {
        return ADD;
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        if (ranges != null && ranges.length == 2) {
            NumberRange<? extends Number> range0 = ranges[0];
            NumberRange<? extends Number> range1 = ranges[1];
            double min0 = range0.getMinimum();
            double min1 = range1.getMinimum();
            double max0 = range0.getMaximum();
            double max1 = range1.getMaximum();
            double max = max0 + max1;
            double min = min0 + min1;
            return NumberRange.create((double)min, (double)max);
        }
        return null;
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        parameters.set((Object)AlgebraDescriptor.Operator.SUM, 0);
        Collection sources = (Collection)parameters2.parameter("sources").getValue();
        for (GridCoverage2D source : sources) {
            Add.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Add.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

