/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class DivideByConst
extends OperationJAI {
    private static final String OPERATION_CONST = "operationConst";
    private static final String DIVIDE_BY_CONST = "DivideByConst";
    private static final long serialVersionUID = -3723238033407316564L;

    public DivideByConst() {
        super(DIVIDE_BY_CONST, DivideByConst.getOperationDescriptor(OPERATION_CONST));
    }

    @Override
    public String getName() {
        return DIVIDE_BY_CONST;
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange<? extends Number> range = ranges[0];
            double min = range.getMinimum() / c;
            double max = range.getMaximum() / c;
            return max < min ? NumberRange.create((double)max, (double)min) : NumberRange.create((double)min, (double)max);
        }
        return super.deriveRange(ranges, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
        parameters.set((Object)AlgebraDescriptor.Operator.DIVIDE, 1);
        DivideByConst.handleROINoDataInternal(parameters, source, OPERATION_CONST, 2, 3);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return DivideByConst.handleROINoDataProperties(null, parameters.parameters, sources[0], OPERATION_CONST, 2, 3, 4);
    }
}

