/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.stats.HistogramWrapper;
import org.eclipse.imagen.media.stats.Statistics;
import org.geotools.api.coverage.processing.OperationNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseStatisticsOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.util.CoverageUtilities;

public class Histogram
extends BaseStatisticsOperationJAI {
    private static final String STATS = "Stats";
    private static final String HISTOGRAM = "Histogram";
    private static final long serialVersionUID = -4256576399698278701L;
    public static final String GT_SYNTHETIC_PROPERTY_HISTOGRAM = "histogram";

    public Histogram() throws OperationNotFoundException {
        super(HISTOGRAM, Histogram.getOperationDescriptor(STATS));
    }

    @Override
    public String getName() {
        return HISTOGRAM;
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        if (data instanceof RenderedOp) {
            RenderedOp result = (RenderedOp)data;
            HashMap<String, Object> synthProp = new HashMap<String, Object>();
            Statistics[][] results = (Statistics[][])result.getProperty("ImageN-EXT.stats");
            int numBands = result.getNumBands();
            int[][] bins = new int[numBands][];
            for (int i = 0; i < results.length; ++i) {
                Statistics stat = results[i][0];
                double[] binsDouble = (double[])stat.getResult();
                bins[i] = new int[binsDouble.length];
                for (int j = 0; j < binsDouble.length; ++j) {
                    bins[i][j] = (int)binsDouble[j];
                }
            }
            ParameterBlock parameterBlock = result.getParameterBlock();
            double[] lowValues = (double[])parameterBlock.getObjectParameter(7);
            double[] highValues = (double[])parameterBlock.getObjectParameter(8);
            int[] numBins = (int[])parameterBlock.getObjectParameter(9);
            HistogramWrapper wrapper = new HistogramWrapper(numBins, lowValues, highValues, (int[][])bins);
            synthProp.put(GT_SYNTHETIC_PROPERTY_HISTOGRAM, wrapper);
            GridCoverage2D source = sources[0];
            CoverageUtilities.setROIProperty(synthProp, CoverageUtilities.getROIProperty(source));
            CoverageUtilities.setNoDataProperty(synthProp, CoverageUtilities.getNoDataProperty(source));
            return Collections.unmodifiableMap(synthProp);
        }
        return super.getProperties(data, crs, name, toCRS, sources, parameters);
    }

    @Override
    protected ParameterBlockImageN prepareParameters(ParameterValueGroup parameters) {
        ParameterBlockImageN block = super.prepareParameters(parameters);
        block.setParameter("lowValue", parameters.parameter("lowValue").getValue());
        block.setParameter("highValue", parameters.parameter("highValue").getValue());
        block.setParameter("numBins", parameters.parameter("numBins").getValue());
        GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter("source0").getValue());
        Histogram.handleROINoDataInternal(block, source, STATS, 2, 3);
        block.set((Object)new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM}, 6);
        int b = source.getRenderedImage().getSampleModel().getNumBands();
        int[] indexes = new int[b];
        for (int i = 0; i < b; ++i) {
            indexes[i] = i;
        }
        block.set((Object)indexes, 5);
        return block;
    }
}

