/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class Invert
extends BaseMathOperationJAI {
    private static final String ALGEBRIC = "algebric";
    private static final String INVERT = "Invert";
    private static final long serialVersionUID = 7297641092994880308L;

    public Invert() {
        super(INVERT, Invert.getOperationDescriptor(ALGEBRIC));
    }

    @Override
    public String getName() {
        return INVERT;
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        NumberRange<? extends Number> range = ranges[0];
        double min = -range.getMaximum();
        double max = -range.getMinimum();
        return NumberRange.create((double)min, (double)max);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        parameters.set((Object)AlgebraDescriptor.Operator.INVERT, 0);
        Collection sources = (Collection)parameters2.parameter("sources").getValue();
        for (GridCoverage2D source : sources) {
            Invert.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Invert.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

