/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class Log
extends BaseMathOperationJAI {
    private static final long serialVersionUID = -3622176942444895367L;
    private static final String ALGEBRIC = "algebric";

    public Log() {
        super("Log", Log.getOperationDescriptor(ALGEBRIC));
    }

    @Override
    public String getName() {
        return "Log";
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        NumberRange<? extends Number> range = ranges[0];
        double min = Math.log(range.getMinimum());
        double max = Math.log(range.getMaximum());
        return NumberRange.create((double)min, (double)max);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        parameters.set((Object)AlgebraDescriptor.Operator.LOG, 0);
        Collection sources = (Collection)parameters2.parameter("sources").getValue();
        for (GridCoverage2D source : sources) {
            Log.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Log.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

