/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseScaleOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.util.CoverageUtilities;

public class Scale
extends BaseScaleOperationJAI {
    private static final long serialVersionUID = -3212656385631097713L;

    public Scale() {
        super("Scale");
    }

    @Override
    protected RenderedImage createRenderedImage(ParameterBlockImageN parameters, RenderingHints hints) {
        RenderedImage source = (RenderedImage)parameters.getSource(0);
        Object interpolation = parameters.getObjectParameter("interpolation") != null ? (Interpolation)parameters.getObjectParameter("interpolation") : (hints.get(ImageN.KEY_INTERPOLATION) != null ? (Interpolation)hints.get(ImageN.KEY_INTERPOLATION) : null);
        int transferType = source.getSampleModel().getDataType();
        ImageN processor = OperationJAI.getJAI(hints);
        Object image = interpolation != null && !(interpolation instanceof InterpolationNearest) && (transferType == 4 || transferType == 5) ? processor.createNS(this.getName(), (ParameterBlock)parameters, hints).getRendering() : processor.createNS(this.getName(), (ParameterBlock)parameters, hints);
        return image;
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
        Scale.handleROINoDataInternal(parameters, source, "Scale", 5, 7);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        Object bkgProp;
        Map props = sources[0].getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (props != null) {
            properties.putAll(props);
        }
        if (parameters.parameters.getNumParameters() > 5 && parameters.parameters.getObjectParameter(8) != null && (bkgProp = parameters.parameters.getObjectParameter(8)) != null && bkgProp instanceof double[]) {
            double[] background = (double[])bkgProp;
            CoverageUtilities.setNoDataProperty(properties, background);
        }
        if (data instanceof RenderedOp) {
            Object roiProp;
            RenderedOp op = (RenderedOp)data;
            String operationName = op.getOperationName();
            PropertyGenerator propertyGenerator = null;
            if (operationName.equalsIgnoreCase("Scale") || operationName.equalsIgnoreCase("Translate")) {
                propertyGenerator = Scale.getOperationDescriptor(operationName).getPropertyGenerators("rendered")[0];
            }
            if (propertyGenerator != null && (roiProp = propertyGenerator.getProperty("roi", (Object)data)) != null && roiProp instanceof ROI) {
                ROI oI = (ROI)roiProp;
                CoverageUtilities.setROIProperty(properties, oI);
            }
        }
        return properties;
    }
}

