/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Map;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.media.algebra.AlgebraDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class SubtractConst
extends OperationJAI {
    private static final String OPERATION_CONST = "operationConst";
    private static final long serialVersionUID = 279426577290256732L;

    public SubtractConst() {
        super("SubtractConst", SubtractConst.getOperationDescriptor(OPERATION_CONST));
    }

    @Override
    public String getName() {
        return "SubtractConst";
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange<? extends Number> range = ranges[0];
            double min = range.getMinimum() - c;
            double max = range.getMaximum() - c;
            return NumberRange.create((double)min, (double)max);
        }
        return super.deriveRange(ranges, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockImageN parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
        parameters.set((Object)AlgebraDescriptor.Operator.SUBTRACT, 1);
        SubtractConst.handleROINoDataInternal(parameters, source, OPERATION_CONST, 2, 3);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return SubtractConst.handleROINoDataProperties(null, parameters.parameters, sources[0], OPERATION_CONST, 2, 3, 4);
    }
}

