/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.GeometricOpImage;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.util.PropertyGeneratorImpl;
import org.geotools.util.factory.Hints;

public class GTAffinePropertyGenerator
extends PropertyGeneratorImpl {
    private static final long serialVersionUID = 6622489670499745306L;
    static boolean registered = false;

    public GTAffinePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public static synchronized void register(boolean force) {
        if (!registered || force) {
            OperationRegistry registry = ImageN.getDefaultInstance().getOperationRegistry();
            registry.addPropertyGenerator("rendered", "Affine", (PropertyGenerator)new GTAffinePropertyGenerator());
            registered = true;
        }
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)opNode;
            if (name.equalsIgnoreCase("roi")) {
                ROI dstROI;
                GeometricOpImage image;
                ParameterBlock pb = op.getParameterBlock();
                RenderedImage src = pb.getRenderedSource(0);
                Object property = src.getProperty("ROI");
                if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                    if (pb.getNumParameters() >= 4 && pb.getObjectParameter(3) != null) {
                        property = pb.getObjectParameter(3);
                    } else {
                        return Image.UndefinedProperty;
                    }
                }
                ROI srcROI = (ROI)property;
                Interpolation interp = (Interpolation)pb.getObjectParameter(1);
                Rectangle srcBounds = null;
                PlanarImage dst = op.getRendering();
                srcBounds = dst instanceof GeometricOpImage && (image = (GeometricOpImage)dst).getBorderExtender() == null ? new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1) : new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
                if (!srcBounds.contains(srcROI.getBounds())) {
                    srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
                }
                AffineTransform transform = (AffineTransform)pb.getObjectParameter(0);
                if (srcROI.getClass().equals(ROI.class)) {
                    ParameterBlock paramBlock = new ParameterBlock();
                    paramBlock.add(transform);
                    paramBlock.add(Interpolation.getInstance((int)0));
                    Hints localHints = new Hints(op.getRenderingHints());
                    localHints.remove((Object)ImageN.KEY_IMAGE_LAYOUT);
                    ImageLayout il = new ImageLayout();
                    Rectangle dstBounds = op.getBounds();
                    il.setMinX(dstBounds.x);
                    il.setMinY(dstBounds.y);
                    il.setWidth(dstBounds.width);
                    il.setHeight(dstBounds.height);
                    il.setTileWidth(op.getTileWidth());
                    il.setTileWidth(op.getTileHeight());
                    localHints.add(new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, il));
                    dstROI = srcROI.performImageOp("Affine", paramBlock, 0, (RenderingHints)localHints);
                } else {
                    dstROI = srcROI.transform(transform);
                }
                Rectangle dstBounds = op.getBounds();
                if (!dstBounds.contains(dstROI.getBounds())) {
                    dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
                }
                return dstROI;
            }
        }
        return Image.UndefinedProperty;
    }
}

