/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import java.awt.image.RasterFormatException;
import org.eclipse.imagen.iterator.RectIter;
import org.eclipse.imagen.iterator.WritableRectIter;

public final class TransfertRectIter
implements WritableRectIter {
    private static final String ERROR = "Size mismatch";
    private final RectIter src;
    private final WritableRectIter dst;

    private TransfertRectIter(RectIter src, WritableRectIter dst) {
        this.src = src;
        this.dst = dst;
    }

    public static WritableRectIter create(RectIter src, WritableRectIter dst) {
        if (src == dst) {
            return dst;
        }
        return new TransfertRectIter(src, dst);
    }

    public void startLines() {
        this.src.startLines();
        this.dst.startLines();
    }

    public void startPixels() {
        this.src.startPixels();
        this.dst.startPixels();
    }

    public void startBands() {
        this.src.startBands();
        this.dst.startBands();
    }

    public void jumpLines(int num) {
        this.src.jumpLines(num);
        this.dst.jumpLines(num);
    }

    public void jumpPixels(int num) {
        this.src.jumpPixels(num);
        this.dst.jumpPixels(num);
    }

    public void nextLine() {
        this.src.nextLine();
        this.dst.nextLine();
    }

    public void nextPixel() {
        this.src.nextPixel();
        this.dst.nextPixel();
    }

    public void nextBand() {
        this.src.nextBand();
        this.dst.nextBand();
    }

    public boolean nextLineDone() {
        boolean check = this.src.nextLineDone();
        if (check == this.dst.nextLineDone()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean nextPixelDone() {
        boolean check = this.src.nextPixelDone();
        if (check == this.dst.nextPixelDone()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean nextBandDone() {
        boolean check = this.src.nextBandDone();
        if (check == this.dst.nextBandDone()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedLines() {
        boolean check = this.src.finishedLines();
        if (check == this.dst.finishedLines()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedPixels() {
        boolean check = this.src.finishedPixels();
        if (check == this.dst.finishedPixels()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public boolean finishedBands() {
        boolean check = this.src.finishedBands();
        if (check == this.dst.finishedBands()) {
            return check;
        }
        throw new RasterFormatException(ERROR);
    }

    public int[] getPixel(int[] array) {
        return this.src.getPixel(array);
    }

    public float[] getPixel(float[] array) {
        return this.src.getPixel(array);
    }

    public double[] getPixel(double[] array) {
        return this.src.getPixel(array);
    }

    public int getSample() {
        return this.src.getSample();
    }

    public int getSample(int b) {
        return this.src.getSample(b);
    }

    public float getSampleFloat() {
        return this.src.getSampleFloat();
    }

    public float getSampleFloat(int b) {
        return this.src.getSampleFloat(b);
    }

    public double getSampleDouble() {
        return this.src.getSampleDouble();
    }

    public double getSampleDouble(int b) {
        return this.src.getSampleDouble(b);
    }

    public void setPixel(int[] array) {
        this.dst.setPixel(array);
    }

    public void setPixel(float[] array) {
        this.dst.setPixel(array);
    }

    public void setPixel(double[] array) {
        this.dst.setPixel(array);
    }

    public void setSample(int s) {
        this.dst.setSample(s);
    }

    public void setSample(float s) {
        this.dst.setSample(s);
    }

    public void setSample(double s) {
        this.dst.setSample(s);
    }

    public void setSample(int b, int s) {
        this.dst.setSample(b, s);
    }

    public void setSample(int b, float s) {
        this.dst.setSample(b, s);
    }

    public void setSample(int b, double s) {
        this.dst.setSample(b, s);
    }
}

