/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.registry.RIFRegistry;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.util.logging.Logging;

public final class Registry {
    public static final String JAI_TOOLS_PRODUCT = "org.jaitools.media.jai";
    public static final String GEOTOOLS_PRODUCT = "org.geotools";

    private Registry() {
    }

    @Deprecated
    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed, ImageN imagen) {
        String product = "org.eclipse.imagen.media";
        OperationRegistry registry = imagen.getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "org.eclipse.imagen.media");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            for (RenderedImageFactory factory : factories) {
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("org.eclipse.imagen.media.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("org.eclipse.imagen.media.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"org.eclipse.imagen.media", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"org.eclipse.imagen.media", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
                LogRecord record = Loggings.format((Level)Level.CONFIG, (int)31, (Object)operation, (Object)(allowed ? 1 : 0));
                Registry.log("setNativeAccelerationAllowed", record);
            }
        }
    }

    @Deprecated
    public static void setNativeAccelerationAllowed(String operation, boolean allowed) {
        Registry.setNativeAccelerationAllowed(operation, allowed, ImageN.getDefaultInstance());
    }

    public static boolean registerRIF(ImageN imagen, OperationDescriptor descriptor, String name, ContextualRenderedImageFactory crif) {
        OperationRegistry registry = imagen.getOperationRegistry();
        try {
            registry.registerDescriptor((RegistryElementDescriptor)descriptor);
            registry.registerFactory("rendered", name, GEOTOOLS_PRODUCT, (Object)crif);
            return true;
        }
        catch (IllegalArgumentException exception) {
            LogRecord record = Loggings.format((Level)Level.SEVERE, (int)10, (Object)name);
            record.setSourceClassName(GridSampleDimension.class.getName());
            record.setSourceMethodName("<classinit>");
            record.setThrown(exception);
            record.setLoggerName(AbstractGridCoverage.LOGGER.getName());
            AbstractGridCoverage.LOGGER.log(record);
            return false;
        }
    }

    public static boolean registerRIF(ImageN imagen, OperationDescriptor descriptor, RenderedImageFactory rif, String productName) {
        OperationRegistry registry = imagen.getOperationRegistry();
        try {
            new ParameterBlockImageN(descriptor.getName());
            return false;
        }
        catch (Exception e) {
            registry.registerDescriptor((RegistryElementDescriptor)descriptor);
            String descName = descriptor.getName();
            registry.registerFactory("rendered", descName, productName, (Object)rif);
            return true;
        }
    }

    private static void log(String method, LogRecord record) {
        record.setSourceClassName(Registry.class.getName());
        record.setSourceMethodName(method);
        Logger logger = Logging.getLogger(Registry.class);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }
}

