/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.OperationDescriptorImpl;

public class ColorInversionDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -8859576263333814317L;
    public static final String OPERATION_NAME = "org.geotools.ColorInversion";

    private static IndexColorModel buildDefaultPalette() {
        int[] cmap = new int[256];
        int i = 0;
        int opaqueAlpha = -16777216;
        for (int r = 0; r < 256; r += 51) {
            for (int g = 0; g < 256; g += 51) {
                for (int b = 0; b < 256; b += 51) {
                    cmap[i] = opaqueAlpha | r << 16 | g << 8 | b;
                    ++i;
                }
            }
        }
        int grayIncr = 256 / (255 - i);
        int gray = 255 - (255 - i - 1) * grayIncr;
        while (i < 255) {
            cmap[i] = opaqueAlpha | gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        cmap[255] = 0xFFFFFF;
        return new IndexColorModel(8, 256, cmap, 0, true, 255, 0);
    }

    public ColorInversionDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "it.geosolutions"}, {"Description", "Produce a paletted imge from an RGB or RGBA image using a provided palette."}, {"DocURL", "http://www.geo-solutions.it/"}, {"Version", "1.0"}, {"arg0Desc", "Indexed color model."}, {"arg1Desc", "Number of colors after the reduction."}, {"arg2Desc", "Threshold for thresholding alpha"}}, new String[]{"rendered"}, 0, new String[]{"IndexColorModel", "quantizationColors", "alphaThreshold"}, new Class[]{IndexColorModel.class, Integer.class, Integer.class}, new Object[]{ColorInversionDescriptor.buildDefaultPalette(), 5, 1}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        if (!(param.getObjectParameter(0) instanceof IndexColorModel)) {
            return false;
        }
        int numColors = (Integer)param.getObjectParameter(1);
        int alphaThreashold = (Integer)param.getObjectParameter(2);
        if (alphaThreashold < 0 || alphaThreashold > 255) {
            return false;
        }
        return numColors > 0 && numColors <= 256;
    }
}

