/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.eclipse.imagen.media.viewer.ImageViewer;
import org.geotools.util.logging.Logging;

class CompareImageDialog
extends JDialog {
    private static final long serialVersionUID = -8640087805737551918L;
    static final Logger LOGGER = Logging.getLogger(CompareImageDialog.class);
    boolean accept = false;

    public CompareImageDialog(RenderedImage expected, RenderedImage actual, boolean showCommands) {
        JPanel content = new JPanel(new BorderLayout());
        this.setContentPane(content);
        this.setTitle("ImageAssert");
        Object message = expected.getWidth() != actual.getWidth() || expected.getHeight() != actual.getHeight() ? "Image sizes are different, expected " + expected.getWidth() + "x" + expected.getHeight() + " but actual is " + actual.getWidth() + "x" + actual.getHeight() : "The two images are perceptibly different.";
        JLabel topLabel = new JLabel("<html><body>" + (String)message + "</html></body>");
        topLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
        content.add((Component)topLabel, "North");
        JPanel central = new JPanel(new GridLayout(1, 2));
        central.add(this.titledImagePanel("Expected", expected));
        central.add(this.titledImagePanel("Actual", actual));
        content.add(central);
        JPanel commands = new JPanel(new FlowLayout(2));
        JButton accept = new JButton("Overwrite reference");
        accept.addActionListener(e -> {
            this.accept = true;
            this.setVisible(false);
        });
        JButton reject = new JButton("Images are different");
        reject.addActionListener(e -> {
            this.accept = false;
            this.setVisible(false);
        });
        JButton save = new JButton("Save comparison");
        save.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Directories (will save a expected.png and actual.png there)";
                }
            });
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                File selected = chooser.getSelectedFile();
                try {
                    ImageIO.write(expected, "PNG", new File(selected, "expected.png"));
                    ImageIO.write(actual, "PNG", new File(selected, "actual.png"));
                }
                catch (IOException e1) {
                    LOGGER.log(Level.WARNING, "Failed to save images", e);
                }
            }
        });
        commands.add(accept);
        commands.add(reject);
        commands.add(save);
        commands.setVisible(showCommands);
        content.add((Component)commands, "South");
        this.pack();
    }

    private Component titledImagePanel(String string, RenderedImage image) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel title = new JLabel(string);
        title.setAlignmentX(0.5f);
        title.setBorder(new LineBorder(Color.BLACK));
        panel.add((Component)title, "North");
        ImageViewer viewer = new ImageViewer();
        viewer.setImage(image);
        panel.add((Component)viewer, "Center");
        return panel;
    }

    public static boolean show(RenderedImage expected, RenderedImage actual, boolean showCommands) {
        CompareImageDialog dialog = new CompareImageDialog(expected, actual, showCommands);
        dialog.setModal(true);
        dialog.setVisible(true);
        return dialog.accept;
    }
}

