/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.util;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    private final int visibleBand;

    public MultiBandsIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int transparent, int transferType, int numBands, int visibleBand) {
        super(bits, size, cmap, start, hasAlpha, transparent, transferType);
        this.numBands = numBands;
        this.visibleBand = visibleBand;
    }

    @Override
    public Object getDataElements(int RGB, Object pixel) {
        if (pixel == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    pixel = new short[this.numBands];
                    break;
                }
                case 0: {
                    pixel = new byte[this.numBands];
                    break;
                }
                case 3: {
                    pixel = new int[this.numBands];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unsupported());
                }
            }
        }
        pixel = super.getDataElements(RGB, pixel);
        switch (this.transferType) {
            case 1: 
            case 2: {
                short[] array = (short[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 0: {
                byte[] array = (byte[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 3: {
                int[] array = (int[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.unsupported());
            }
        }
        return pixel;
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        return this.getComponents(switch (this.transferType) {
            case 1, 2 -> ((short[])pixel)[this.visibleBand] & 0xFFFF;
            case 0 -> ((byte[])pixel)[this.visibleBand] & 0xFF;
            case 3 -> ((int[])pixel)[this.visibleBand];
            default -> throw new UnsupportedOperationException(this.unsupported());
        }, components, offset);
    }

    @Override
    public int getRed(Object inData) {
        return this.getRed(switch (this.transferType) {
            case 0 -> ((byte[])inData)[this.visibleBand] & 0xFF;
            case 1 -> ((short[])inData)[this.visibleBand] & 0xFFFF;
            case 3 -> ((int[])inData)[this.visibleBand];
            default -> throw new UnsupportedOperationException(this.unsupported());
        });
    }

    @Override
    public int getGreen(Object inData) {
        return this.getGreen(switch (this.transferType) {
            case 0 -> ((byte[])inData)[this.visibleBand] & 0xFF;
            case 1 -> ((short[])inData)[this.visibleBand] & 0xFFFF;
            case 3 -> ((int[])inData)[this.visibleBand];
            default -> throw new UnsupportedOperationException(this.unsupported());
        });
    }

    @Override
    public int getBlue(Object inData) {
        return this.getBlue(switch (this.transferType) {
            case 0 -> ((byte[])inData)[this.visibleBand] & 0xFF;
            case 1 -> ((short[])inData)[this.visibleBand] & 0xFFFF;
            case 3 -> ((int[])inData)[this.visibleBand];
            default -> throw new UnsupportedOperationException(this.unsupported());
        });
    }

    @Override
    public int getAlpha(Object inData) {
        return this.getAlpha(switch (this.transferType) {
            case 0 -> ((byte[])inData)[this.visibleBand] & 0xFF;
            case 1 -> ((short[])inData)[this.visibleBand] & 0xFFFF;
            case 3 -> ((int[])inData)[this.visibleBand];
            default -> throw new UnsupportedOperationException(this.unsupported());
        });
    }

    private String unsupported() {
        return "This method has not been implemented for transferType " + this.transferType;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int width, int height) {
        return Raster.createBandedRaster(this.transferType, width, height, this.numBands, null);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public SampleModel createCompatibleSampleModel(int width, int height) {
        return new BandedSampleModel(this.transferType, width, height, this.numBands);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm instanceof ComponentSampleModel && sm.getTransferType() == this.transferType && sm.getNumBands() == this.numBands && 1 << sm.getSampleSize(this.visibleBand) >= this.getMapSize();
    }
}

