/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.v1_0.OGC;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class OGCUtils {
    static Object property(Expression e1, Expression e2, QName name) {
        Literal literal;
        Literal literal2;
        if (OGC.PropertyName.equals(name)) {
            if (e1 instanceof PropertyName) {
                return e1;
            }
            if (e2 instanceof PropertyName) {
                return e2;
            }
        }
        if (new QName("http://www.opengis.net/gml", "_Geometry").equals(name)) {
            if (e1 instanceof Literal) {
                literal2 = (Literal)e1;
                if (literal2.getValue() instanceof Geometry) {
                    return literal2.getValue();
                }
            } else if (e2 instanceof Literal && (literal = (Literal)e2).getValue() instanceof Geometry) {
                return literal.getValue();
            }
        }
        if (new QName("http://www.opengis.net/gml", "Box").equals(name) || new QName("http://www.opengis.net/gml", "Envelope").equals(name)) {
            if (e1 instanceof Literal) {
                literal2 = (Literal)e1;
                if (literal2.getValue() instanceof Envelope) {
                    return literal2.getValue();
                }
            } else if (e2 instanceof Literal && (literal = (Literal)e2).getValue() instanceof Envelope) {
                return literal.getValue();
            }
        }
        return null;
    }

    static Expression[] spatial(Node node, FilterFactory ff, GeometryFactory gf) {
        List names = node.getChildValues(PropertyName.class);
        if (names.size() == 2) {
            return new Expression[]{(Expression)names.get(0), (Expression)names.get(1)};
        }
        PropertyName name = (PropertyName)node.getChildValue(PropertyName.class);
        Literal spatial = null;
        if (node.hasChild(Geometry.class)) {
            spatial = ff.literal(node.getChildValue(Geometry.class));
        } else if (node.hasChild(Envelope.class)) {
            Envelope envelope = (Envelope)node.getChildValue(Envelope.class);
            Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
            if (envelope instanceof ReferencedEnvelope) {
                ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)envelope;
                polygon.setUserData((Object)referencedEnvelope.getCoordinateReferenceSystem());
            }
            spatial = ff.literal((Object)polygon);
        } else {
            for (Node child : node.getChildren()) {
                if (child.getValue() instanceof PropertyName || !(child.getValue() instanceof Expression)) continue;
                spatial = (Expression)child.getValue();
                break;
            }
        }
        return new Expression[]{name, spatial};
    }
}

