/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Response;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wcs.response.CoveragesTransformer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wcs.WcsException;

public class WCSGetCoverageStoreResponse
extends Response {
    static final Logger LOGGER = Logging.getLogger(WCSGetCoverageStoreResponse.class);
    GeoServer geoServer;
    Catalog catalog;
    CoverageResponseDelegateFinder responseFactory;

    public WCSGetCoverageStoreResponse(GeoServer gs, CoverageResponseDelegateFinder responseFactory) {
        super(GridCoverage[].class);
        this.geoServer = gs;
        this.catalog = gs.getCatalog();
        this.responseFactory = responseFactory;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/xml";
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return getCoverage.getOutput().isStore();
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat();
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoverageInfo coverageInfo = this.catalog.getCoverageByName(request.getIdentifier().getValue());
        Resource wcsStore = null;
        try {
            GeoServerResourceLoader loader = this.geoServer.getCatalog().getResourceLoader();
            wcsStore = loader.get("temp/wcs");
        }
        catch (Exception e) {
            throw new WcsException("Could not create the temporary storage directory for WCS");
        }
        Resource coverageFile = null;
        while (Resources.exists((Resource)(coverageFile = wcsStore.get(coverageInfo.getName().replace(':', '_') + "_" + System.nanoTime() + "." + delegate.getFileExtension(outputFormat))))) {
        }
        try (BufferedOutputStream os = new BufferedOutputStream(coverageFile.out());){
            delegate.encode(coverage, outputFormat, Collections.emptyMap(), (OutputStream)os);
            ((OutputStream)os).flush();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Saving coverage to temp file: " + String.valueOf(coverageFile));
        }
        String coverageLocation = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{"temp/wcs", coverageFile.name()}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        CoveragesTransformer tx = new CoveragesTransformer(request, coverageLocation);
        try {
            tx.transform(coverageInfo, output);
        }
        catch (TransformerException e) {
            throw new WcsException("Failure trying to encode Coverages response", (Throwable)e);
        }
    }
}

