/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.imageread;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.imagen.CRIFImpl;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.PropertySource;
import org.eclipse.imagen.WritablePropertySource;
import org.eclipse.imagen.media.imageread.I18N;
import org.eclipse.imagen.media.imageread.ImageReadOpImage;

public final class ImageReadCRIF
extends CRIFImpl {
    /*
     * Unable to fully structure code
     */
    private static ImageInputStream getImageInputStream(Object input) {
        stream = null;
        if (input instanceof ImageInputStream) {
            return (ImageInputStream)input;
        }
        if (input instanceof String) {
            try {
                input = new RandomAccessFile((String)input, "r");
            }
            catch (Exception e) {
                input = ImageReadCRIF.class.getClassLoader().getResourceAsStream((String)input);
                if (input != null) ** GOTO lbl25
                throw new RuntimeException(I18N.getString("ImageReadCRIF0") + " " + String.valueOf(input));
            }
        } else {
            if (input instanceof URL) {
                try {
                    input = ((URL)input).openStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF1") + " " + String.valueOf(input));
                }
            }
            if (input instanceof Socket) {
                try {
                    socket = (Socket)input;
                    input = socket.getInputStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF2") + " " + String.valueOf(input));
                }
            }
        }
lbl25:
        // 6 sources

        try {
            stream = ImageIO.createImageInputStream(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    static ImageReader getImageReader(ParameterBlock pb) {
        Iterator<ImageReader> readers;
        Object input = pb.getObjectParameter(0);
        ImageReader reader = (ImageReader)pb.getObjectParameter(8);
        ImageInputStream stream = ImageReadCRIF.getImageInputStream(input);
        if (reader == null && (readers = ImageIO.getImageReaders(stream != null ? stream : input)) != null && readers.hasNext()) {
            do {
                ImageReader tmpReader = readers.next();
                ImageReaderSpi readerSpi = tmpReader.getOriginatingProvider();
                try {
                    if (!readerSpi.canDecodeInput(stream != null ? stream : input)) continue;
                    reader = tmpReader;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (reader == null && readers.hasNext());
        }
        if (reader != null) {
            EventListener[] listeners;
            Locale locale = (Locale)pb.getObjectParameter(6);
            if (locale != null) {
                reader.setLocale(locale);
            }
            if ((listeners = (EventListener[])pb.getObjectParameter(5)) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    EventListener listener = listeners[i];
                    if (listener instanceof IIOReadProgressListener) {
                        reader.addIIOReadProgressListener((IIOReadProgressListener)listener);
                    }
                    if (listener instanceof IIOReadUpdateListener) {
                        reader.addIIOReadUpdateListener((IIOReadUpdateListener)listener);
                    }
                    if (!(listener instanceof IIOReadWarningListener)) continue;
                    reader.addIIOReadWarningListener((IIOReadWarningListener)listener);
                }
            }
            boolean readMetadata = (Boolean)pb.getObjectParameter(2);
            reader.setInput(stream != null ? stream : input, false, !readMetadata);
        }
        return reader;
    }

    static void copyProperty(PropertySource ps, WritablePropertySource wps, String propertyName) {
        Object propertyValue = ps.getProperty(propertyName);
        if (propertyValue != null && !propertyValue.equals(Image.UndefinedProperty)) {
            wps.setProperty(propertyName, propertyValue);
        }
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints rh) {
        ImageReadOpImage image = null;
        ImageReader reader = ImageReadCRIF.getImageReader(pb);
        if (reader != null) {
            boolean closeReader = !(pb.getObjectParameter(0) instanceof ImageReader);
            int imageIndex = pb.getIntParameter(1);
            ImageReadParam param = (ImageReadParam)pb.getObjectParameter(7);
            boolean readThumbnails = (Boolean)pb.getObjectParameter(3);
            ImageLayout layout = rh != null && rh.containsKey(ImageN.KEY_IMAGE_LAYOUT) ? (ImageLayout)rh.get(ImageN.KEY_IMAGE_LAYOUT) : new ImageLayout();
            try {
                Object paramInput = pb.getObjectParameter(0);
                Object readerInput = reader.getInput();
                ImageInputStream streamToClose = null;
                if (readerInput != paramInput && readerInput instanceof ImageInputStream) {
                    streamToClose = (ImageInputStream)readerInput;
                }
                image = new ImageReadOpImage(layout, rh, param, reader, imageIndex, readThumbnails, streamToClose, closeReader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return image;
    }
}

