/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.data.Diff;
import org.geotools.data.wfs.MutableFeatureId;
import org.geotools.data.wfs.WFSContentState;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDiff;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.TransactionRequest;
import org.geotools.data.wfs.internal.TransactionResponse;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.factory.Hints;

class WFSRemoteTransactionState
implements Transaction.State {
    private final WFSDataStore dataStore;
    private Map<Name, WFSContentState> localStates;

    public WFSRemoteTransactionState(WFSDataStore dataStore) {
        this.dataStore = dataStore;
        this.localStates = new HashMap<Name, WFSContentState>();
    }

    public synchronized WFSDiff getDiff(Name typeName) {
        WFSContentState localState = this.localStates.get(typeName);
        if (null == localState) {
            throw new IllegalStateException("Not watching " + String.valueOf(typeName));
        }
        WFSDiff diff = localState.getLocalTransactionState().getDiff();
        return diff;
    }

    public void setTransaction(Transaction transaction) {
    }

    public void rollback() throws IOException {
        this.clear();
    }

    public void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        try {
            this.commitInternal();
        }
        finally {
            this.clear();
        }
    }

    private void clear() {
        for (WFSContentState localState : this.localStates.values()) {
            WFSLocalTransactionState localTransactionState = localState.getLocalTransactionState();
            WFSDiff diff = localTransactionState.getDiff();
            diff.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitInternal() throws IOException {
        if (this.localStates.isEmpty()) {
            return;
        }
        WFSClient wfs = this.dataStore.getWfsClient();
        TransactionRequest transactionRequest = wfs.createTransaction();
        ArrayList<MutableFeatureId> requestedInsertFids = new ArrayList<MutableFeatureId>();
        for (Name typeName : this.localStates.keySet()) {
            List<MutableFeatureId> addedFids = this.applyDiff(typeName, transactionRequest);
            requestedInsertFids.addAll(addedFids);
        }
        TransactionResponse transactionResponse = wfs.issueTransaction(transactionRequest);
        try {
            List<FeatureId> insertedFids = transactionResponse.getInsertedFids();
            int deleteCount = transactionResponse.getDeleteCount();
            int updatedCount = transactionResponse.getUpdatedCount();
            Loggers.trace(this.getClass().getSimpleName(), "::commit(): Updated: ", updatedCount, ", Deleted: ", deleteCount, ", Inserted: ", insertedFids);
            if (requestedInsertFids.size() != insertedFids.size()) {
                throw new IllegalStateException("Asked to add " + requestedInsertFids.size() + " Features but got " + insertedFids.size() + " insert results");
            }
            for (int i = 0; i < requestedInsertFids.size(); ++i) {
                MutableFeatureId local = (MutableFeatureId)((Object)requestedInsertFids.get(i));
                FeatureId inserted = insertedFids.get(i);
                local.setID(inserted.getID());
                local.setFeatureVersion(inserted.getFeatureVersion());
            }
        }
        finally {
            transactionResponse.dispose();
        }
    }

    private List<MutableFeatureId> applyDiff(Name localTypeName, TransactionRequest transactionRequest) throws IOException {
        WFSContentState localState = this.localStates.get(localTypeName);
        WFSLocalTransactionState localTransactionState = localState.getLocalTransactionState();
        WFSDiff diff = localTransactionState.getDiff();
        LinkedList<MutableFeatureId> addedFeatureIds = new LinkedList<MutableFeatureId>();
        QName remoteTypeName = this.dataStore.getRemoteTypeName(localTypeName);
        this.applyBatchUpdates(remoteTypeName, diff, transactionRequest);
        Set<String> ignored = diff.getBatchModified();
        SimpleFeatureType remoteType = this.dataStore.getRemoteSimpleFeatureType(remoteTypeName);
        Map added = diff.getAdded();
        if (!added.isEmpty()) {
            TransactionRequest.Insert insert = transactionRequest.createInsert(remoteTypeName);
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(remoteType);
            for (String fid : diff.getAddedOrder()) {
                if (ignored.contains(fid)) continue;
                SimpleFeature localFeature = (SimpleFeature)added.get(fid);
                MutableFeatureId addedFid = (MutableFeatureId)localFeature.getIdentifier();
                addedFeatureIds.add(addedFid);
                SimpleFeature remoteFeature = SimpleFeatureBuilder.retype((SimpleFeature)localFeature, (SimpleFeatureBuilder)builder);
                if (Boolean.TRUE.equals(localFeature.getUserData().get(Hints.USE_PROVIDED_FID))) {
                    remoteFeature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                }
                insert.add(remoteFeature);
            }
            transactionRequest.add(insert);
        }
        Map modified = diff.getModified();
        LinkedHashSet<Identifier> ids = new LinkedHashSet<Identifier>();
        for (Map.Entry entry : modified.entrySet()) {
            String rid;
            if (Diff.NULL != entry.getValue() || ignored.contains(rid = (String)entry.getKey())) continue;
            Identifier featureId = this.featureId(rid);
            ids.add(featureId);
        }
        if (!ids.isEmpty()) {
            Id deleteFilter = this.dataStore.getFilterFactory().id(ids);
            TransactionRequest.Delete delete = transactionRequest.createDelete(remoteTypeName, (Filter)deleteFilter);
            transactionRequest.add(delete);
        }
        for (Map.Entry entry : modified.entrySet()) {
            String fid = (String)entry.getKey();
            SimpleFeature feature = (SimpleFeature)entry.getValue();
            if (Diff.NULL == feature || ignored.contains(fid)) continue;
            this.applySingleUpdate(remoteTypeName, feature, transactionRequest);
        }
        return addedFeatureIds;
    }

    private void applySingleUpdate(QName remoteTypeName, SimpleFeature feature, TransactionRequest transactionRequest) throws IOException {
        Collection properties = feature.getProperties();
        ArrayList<QName> propertyNames = new ArrayList<QName>();
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (Property p : properties) {
            QName attName = new QName(remoteTypeName.getNamespaceURI(), p.getName().getLocalPart());
            Object attValue = p.getValue();
            propertyNames.add(attName);
            newValues.add(attValue);
        }
        Id updateFilter = this.dataStore.getFilterFactory().id(Collections.singleton(feature.getIdentifier()));
        TransactionRequest.Update update = transactionRequest.createUpdate(remoteTypeName, propertyNames, newValues, (Filter)updateFilter);
        transactionRequest.add(update);
    }

    private void applyBatchUpdates(QName remoteTypeName, WFSDiff diff, TransactionRequest transactionRequest) {
        List<WFSDiff.BatchUpdate> batchUpdates = diff.getBatchUpdates();
        for (WFSDiff.BatchUpdate batch : batchUpdates) {
            ArrayList<QName> propertyNames = new ArrayList<QName>(batch.properties.length);
            for (Name attName : batch.properties) {
                propertyNames.add(new QName(remoteTypeName.getNamespaceURI(), attName.getLocalPart()));
            }
            List<Object> newValues = Arrays.asList(batch.values);
            Filter updateFilter = batch.filter;
            TransactionRequest.Update update = transactionRequest.createUpdate(remoteTypeName, propertyNames, newValues, updateFilter);
            transactionRequest.add(update);
        }
    }

    private Identifier featureId(String rid) {
        FilterFactory ff = this.dataStore.getFilterFactory();
        String fid = rid;
        String featureVersion = null;
        int versionSeparatorIdx = rid.indexOf(64);
        if (-1 != versionSeparatorIdx) {
            fid = rid.substring(0, versionSeparatorIdx);
            featureVersion = rid.substring(versionSeparatorIdx + 1);
        }
        FeatureId featureId = ff.featureId(fid, featureVersion);
        return featureId;
    }

    public void watch(WFSContentState localState) {
        Name typeName = localState.getEntry().getName();
        this.localStates.put(typeName, localState);
    }
}

