/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.impl;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.impl.WFSContentDataAccess;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSContentComplexFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;

public class WFSContentComplexFeatureSource
implements FeatureSource<FeatureType, Feature> {
    private Name typeName;
    private WFSClient client;
    private WFSContentDataAccess dataAccess;
    private static Logger LOGGER = Logging.getLogger(WFSContentComplexFeatureSource.class);

    public WFSContentComplexFeatureSource(Name typeName, WFSClient client, WFSContentDataAccess dataAccess) {
        this.typeName = typeName;
        this.client = client;
        this.dataAccess = dataAccess;
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.typeName.getLocalPart(), filter));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        if (query.getTypeName() != null && !this.typeName.getLocalPart().equals(query.getTypeName())) {
            throw new IllegalArgumentException("Query's local typeName %s doesn't match the one of this feature source %s.".formatted(query.getTypeName(), this.typeName.getLocalPart()));
        }
        GetFeatureRequest request = this.client.createGetFeatureRequest();
        FeatureType schema = this.dataAccess.getSchema(this.typeName);
        QName name = this.dataAccess.getRemoteTypeName(this.typeName);
        request.setTypeName(name);
        request.setFullType(schema);
        request.setFilter(query.getFilter());
        request.setPropertyNames(query.getPropertyNames());
        request.setSortBy(query.getSortBy());
        if (query.getCoordinateSystem() != null) {
            request.findSupportedSrsName(query.getCoordinateSystem());
            if (request.getSrsName() == null) {
                LOGGER.log(Level.WARNING, "WFS doesn't support the coordinate system: " + String.valueOf(query.getCoordinateSystem()));
            }
        }
        return new WFSContentComplexFeatureCollection(request, schema, name, this.client);
    }

    public Name getName() {
        return this.typeName;
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(WFSContentComplexFeatureSource.this.getName().getURI());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return WFSContentComplexFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return WFSContentComplexFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return WFSContentComplexFeatureSource.this.getName().getURI();
            }

            public URI getSchema() {
                Name name = WFSContentComplexFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = WFSContentComplexFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.dataAccess;
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities();
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public FeatureType getSchema() {
        try {
            return this.dataAccess.getSchema(this.typeName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return null;
        }
        QName name = this.dataAccess.getRemoteTypeName(this.typeName);
        CoordinateReferenceSystem targetCrs = query.getCoordinateSystemReproject() != null ? query.getCoordinateSystemReproject() : this.client.getDefaultCRS(name);
        return this.client.getBounds(name, targetCrs);
    }

    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return Collections.emptySet();
    }
}

