/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.capability.ComparisonOperators;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.filter.capability.ScalarCapabilities;
import org.geotools.api.filter.capability.SpatialCapabilities;
import org.geotools.api.filter.capability.SpatialOperators;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.DescribeStoredQueriesRequest;
import org.geotools.data.wfs.internal.GetCapabilitiesRequest;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.ListStoredQueriesRequest;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.TransactionRequest;
import org.geotools.data.wfs.internal.URIs;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.filter.Capabilities;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.filter.v2_0.FES;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.Version;
import org.geotools.wfs.v1_0.WFSCapabilitiesConfiguration;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterCompliancePreProcessor;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public abstract class AbstractWFSStrategy
extends WFSStrategy {
    protected static final Logger LOGGER = Loggers.MODULE;
    public static final Configuration FILTER_1_0_CONFIGURATION = new org.geotools.filter.v1_0.OGCConfiguration();
    public static final Configuration WFS_1_0_CAPABILITIES_CONFIGURATION = new WFSCapabilitiesConfiguration();
    public static final Configuration WFS_1_0_CONFIGURATION = new WFSConfiguration_1_0();
    public static final Configuration FILTER_1_1_CONFIGURATION = new OGCConfiguration();
    public static final Configuration WFS_1_1_CONFIGURATION = new org.geotools.wfs.v1_1.WFSConfiguration();
    public static final Configuration FILTER_2_0_CONFIGURATION = new FESConfiguration();
    public static final Configuration WFS_2_0_CONFIGURATION = new WFSConfiguration();
    protected WFSConfig config = new WFSConfig();

    protected abstract QName getOperationName(WFSOperationType var1);

    protected void updatePropertyNames(GetFeatureRequest request, Filter unsupportedFilter) {
        if (Filter.INCLUDE.equals(unsupportedFilter)) {
            return;
        }
        String[] propertyNames = request.getPropertyNames();
        if (propertyNames != null) {
            HashSet<String> propertyNamesSet = new HashSet<String>(Arrays.asList(propertyNames));
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            unsupportedFilter.accept((FilterVisitor)extractor, null);
            HashSet<String> extraAttributes = new HashSet<String>(Arrays.asList(extractor.getAttributeNames()));
            propertyNamesSet.addAll(extraAttributes);
            if (propertyNames.length < propertyNamesSet.size()) {
                propertyNames = propertyNamesSet.toArray(new String[propertyNamesSet.size()]);
                request.setPropertyNames(propertyNames);
                request.setQueryType(null);
            }
        }
    }

    protected abstract EObject createDescribeFeatureTypeRequestPost(DescribeFeatureTypeRequest var1);

    protected abstract EObject createGetFeatureRequestPost(GetFeatureRequest var1) throws IOException;

    protected abstract EObject createTransactionRequest(TransactionRequest var1) throws IOException;

    protected abstract EObject createListStoredQueriesRequestPost(ListStoredQueriesRequest var1) throws IOException;

    protected abstract EObject createDescribeStoredQueriesRequestPost(DescribeStoredQueriesRequest var1) throws IOException;

    protected abstract Configuration getFilterConfiguration();

    @Override
    public abstract Configuration getWfsConfiguration();

    public String getVersion() {
        return this.getServiceVersion().toString();
    }

    public GetCapabilitiesRequest createGetCapabilitiesRequest(URL server) {
        return new GetCapabilitiesRequest(server);
    }

    @Override
    public void setConfig(WFSConfig config) {
        this.config = config;
    }

    @Override
    public WFSConfig getConfig() {
        return this.config;
    }

    protected String encodePropertyName(String propertyName) {
        return propertyName;
    }

    protected Map<String, String> buildGetFeatureParametersForGET(GetFeatureRequest request) {
        Loggers.requestDebug("Creating GetFeature request parameters for ", request.getTypeName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SERVICE", "WFS");
        Version serviceVersion = this.getServiceVersion();
        map.put("VERSION", serviceVersion.toString());
        map.put("REQUEST", "GetFeature");
        String outputFormat = request.getOutputFormat();
        if (outputFormat == null) {
            outputFormat = this.getDefaultOutputFormat(WFSOperationType.GET_FEATURE);
        }
        map.put("OUTPUTFORMAT", outputFormat);
        map.put("RESULTTYPE", request.getResultType().name());
        QName typeName = request.getTypeName();
        String queryTypeName = this.getPrefixedTypeName(typeName);
        map.put("TYPENAME", queryTypeName);
        String srsName = request.getSrsName();
        if (srsName != null) {
            map.put("SRSNAME", srsName.toString());
        }
        Filter filter = request.getFilter();
        Filter[] splitFilters = this.splitFilters(typeName, filter);
        Filter supportedFilter = splitFilters[0];
        Filter unsupportedFilter = splitFilters[1];
        Loggers.requestTrace("Supported filter: ", supportedFilter, ". Unsupported filter: ", unsupportedFilter);
        request.setUnsupportedFilter(unsupportedFilter);
        this.updatePropertyNames(request, unsupportedFilter);
        if (!Filter.INCLUDE.equals(unsupportedFilter)) {
            request.setMaxFeatures(null);
        }
        if (supportedFilter instanceof Id) {
            Id id1 = (Id)supportedFilter;
            Set identifiers = id1.getIdentifiers();
            StringBuffer idValues = new StringBuffer();
            Iterator it = identifiers.iterator();
            while (it.hasNext()) {
                Object id = ((Identifier)it.next()).getID();
                if (id instanceof FeatureId) {
                    FeatureId featureId = (FeatureId)id;
                    idValues.append(featureId.getRid());
                } else {
                    idValues.append(String.valueOf(id));
                }
                if (!it.hasNext()) continue;
                idValues.append(",");
            }
            map.put("FEATUREID", idValues.toString());
        } else if (Filter.INCLUDE != supportedFilter) {
            String xmlEncodedFilter;
            try {
                xmlEncodedFilter = this.encodeGetFeatureGetFilter(supportedFilter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            map.put("FILTER", xmlEncodedFilter);
        }
        if (request.getMaxFeatures() != null) {
            map.put("MAXFEATURES", String.valueOf(request.getMaxFeatures()));
        }
        if (request.getStartIndex() != null && this.canOffset()) {
            map.put("STARTINDEX", String.valueOf(request.getStartIndex()));
        }
        if (request.getPropertyNames() != null && request.getPropertyNames().length > 0) {
            List<String> propertyNames = Arrays.asList(request.getPropertyNames());
            StringBuilder pnames = new StringBuilder();
            Iterator<String> it = propertyNames.iterator();
            while (it.hasNext()) {
                pnames.append(it.next());
                if (!it.hasNext()) continue;
                pnames.append(',');
            }
            map.put("PROPERTYNAME", this.encodePropertyName(pnames.toString()));
        }
        return map;
    }

    protected String encodeGetFeatureGetFilter(Filter filter) throws IOException {
        Configuration filterConfig = this.getFilterConfiguration();
        QName encName = filterConfig instanceof org.geotools.filter.v1_0.OGCConfiguration || filterConfig instanceof OGCConfiguration ? OGC.Filter : FES.Filter;
        Encoder encoder = new Encoder(filterConfig);
        encoder.setOmitXMLDeclaration(true);
        encoder.setEncoding(StandardCharsets.UTF_8);
        String encoded = encoder.encodeAsString((Object)filter, encName);
        encoded = encoded.replaceAll("\n", "");
        return encoded;
    }

    @Override
    public abstract Version getServiceVersion();

    protected String getPrefixedTypeName(QName qname) {
        String prefix = qname.getPrefix();
        Object simpleName = "".equals(prefix) ? qname.getLocalPart() : prefix + ":" + qname.getLocalPart();
        return simpleName;
    }

    @Override
    public boolean supportsOperation(WFSOperationType operation, HttpMethod method) {
        return null != this.getOperationURI(operation, method);
    }

    @Override
    public URL getOperationURL(WFSOperationType operation, HttpMethod method) {
        String href = this.getOperationURI(operation, method);
        if (href != null) {
            try {
                return new URL(href);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.INFO, "Malformed " + String.valueOf((Object)method) + " URL for " + String.valueOf((Object)operation), e);
            }
        }
        return null;
    }

    protected abstract String getOperationURI(WFSOperationType var1, HttpMethod var2);

    @Override
    public String getDefaultOutputFormat(WFSOperationType operation) {
        Set<String> supportedOutputFormats = this.getServerSupportedOutputFormats(operation);
        String overrideOutputFormat = this.config.getOutputformatOverride();
        if (overrideOutputFormat != null && supportedOutputFormats.contains(overrideOutputFormat)) {
            return overrideOutputFormat;
        }
        List<String> clientSupportedFormats = this.getClientSupportedOutputFormats(operation);
        for (String clientSupported : clientSupportedFormats) {
            if (!supportedOutputFormats.contains(clientSupported)) continue;
            return clientSupported;
        }
        throw new IllegalArgumentException("Client does not support any of the server supported output formats for " + String.valueOf((Object)operation));
    }

    @Override
    public void dispose() {
    }

    protected Map<String, String> buildDescribeFeatureTypeParametersForGET(DescribeFeatureTypeRequest request) {
        QName typeName = request.getTypeName();
        this.getFeatureTypeInfo(typeName);
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("SERVICE", "WFS");
        kvp.put("VERSION", this.getServiceVersion().toString());
        kvp.put("REQUEST", "DescribeFeatureType");
        return this.buildDescribeFeatureTypeParametersForGET(kvp, typeName);
    }

    protected Map<String, String> buildDescribeFeatureTypeParametersForGET(Map<String, String> kvp, QName typeName) {
        String prefixedTypeName = this.getPrefixedTypeName(typeName);
        kvp.put("TYPENAME", prefixedTypeName);
        if (!"".equals(typeName.getPrefix())) {
            String nsUri = typeName.getNamespaceURI();
            kvp.put("NAMESPACE", "xmlns(" + typeName.getPrefix() + "=" + nsUri + ")");
        }
        return kvp;
    }

    protected Map<String, String> buildDescribeStoredQueriesParametersForGET(DescribeStoredQueriesRequest request) {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("SERVICE", "WFS");
        kvp.put("VERSION", this.getServiceVersion().toString());
        kvp.put("REQUEST", "DescribeStoredQueries");
        if (!request.getStoredQueryIds().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (URI storedQueryId : request.getStoredQueryIds()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(storedQueryId.toString());
            }
            kvp.put("STOREDQUERY_ID", sb.toString());
        }
        return kvp;
    }

    protected Map<String, String> buildListStoredQueriesParametersForGET(ListStoredQueriesRequest request) {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("SERVICE", "WFS");
        kvp.put("VERSION", this.getServiceVersion().toString());
        kvp.put("REQUEST", "ListStoredQueries");
        return kvp;
    }

    protected Encoder prepareEncoder(WFSRequest request) {
        Configuration configuration = this.getWfsConfiguration();
        Charset charset = this.getConfig().getDefaultEncoding();
        if (null == charset) {
            charset = StandardCharsets.UTF_8;
        }
        Encoder encoder = new Encoder(configuration);
        encoder.setEncoding(charset);
        encoder.setIndentSize(1);
        HashSet<QName> typeNames = new HashSet<QName>();
        if (request instanceof TransactionRequest) {
            TransactionRequest tx = (TransactionRequest)request;
            typeNames.addAll(tx.getTypeNames());
        } else {
            QName typeName = request.getTypeName();
            if (typeName != null) {
                typeNames.add(typeName);
            }
        }
        int i = 0;
        for (QName typeName : typeNames) {
            Object prefix = typeName.getPrefix();
            String namespaceURI = typeName.getNamespaceURI();
            if ("".equals(namespaceURI)) continue;
            if ("".equals(prefix)) {
                prefix = "type_ns" + i;
            }
            encoder.getNamespaces().declarePrefix((String)prefix, namespaceURI);
            ++i;
        }
        return encoder;
    }

    @Override
    public Filter[] splitFilters(QName typeName, Filter filter) {
        IncludeFilter post;
        Id server;
        FilterCapabilities filterCapabilities = this.getFilterCapabilities();
        Capabilities filterCaps = new Capabilities();
        if (filterCapabilities != null) {
            SpatialOperators spatialOps;
            SpatialCapabilities spatialCaps;
            filterCaps.addAll(filterCapabilities);
            if (Versions.v1_0_0.equals((Object)this.getServiceVersion()) && (spatialCaps = filterCapabilities.getSpatialCapabilities()) != null && (spatialOps = spatialCaps.getSpatialOperators()) != null && null != spatialOps.getOperator("Intersect")) {
                Loggers.trace("WFS 1.0 capabilities states the spatial operator Intersect. ", "Assuming it is Intersects and adding Intersects as a supported filter type");
                filterCaps.addName("Intersects");
            }
            if (Versions.v2_0_0.equals((Object)this.getServiceVersion())) {
                spatialCaps = filterCapabilities.getScalarCapabilities();
                this.addNamesFilterOGC((ScalarCapabilities)spatialCaps, filterCaps);
            }
        }
        filter = this.simplify(filter);
        Integer complianceLevel = this.getConfig().getFilterCompliance();
        if (null == complianceLevel) {
            complianceLevel = XMLHandlerHints.VALUE_FILTER_COMPLIANCE_HIGH;
        }
        FilterCompliancePreProcessor compliancePreProcessor = new FilterCompliancePreProcessor(complianceLevel);
        filter.accept((FilterVisitor)compliancePreProcessor, null);
        filter = compliancePreProcessor.getFilter();
        Id fidFilter = compliancePreProcessor.getFidFilter();
        if (!fidFilter.getIdentifiers().isEmpty()) {
            server = fidFilter;
            post = Filter.EXCLUDE.equals(filter) ? Filter.INCLUDE : filter;
        } else {
            CapabilitiesFilterSplitter splitter = new CapabilitiesFilterSplitter(filterCaps, null, null);
            filter.accept((FilterVisitor)splitter, null);
            server = splitter.getFilterPre();
            post = splitter.getFilterPost();
        }
        return new Filter[]{server, post};
    }

    private void addNamesFilterOGC(ScalarCapabilities spatialCaps, Capabilities resFilterCaps) {
        ComparisonOperators spatialOps;
        if (spatialCaps != null && (spatialOps = spatialCaps.getComparisonOperators()) != null) {
            this.addNameFilterOGC(spatialOps, "PropertyIsGreaterThan", "GreaterThan", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsNotEqualTo", "NotEqualTo", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsLessThanOrEqualTo", "LessThanEqualTo", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsGreaterThanOrEqualTo", "GreaterThanEqualTo", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsLike", "Like", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsNil", "Nil", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsEqualTo", "EqualTo", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsNull", "NullCheck", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsBetween", "Between", resFilterCaps);
            this.addNameFilterOGC(spatialOps, "PropertyIsLessThan", "LessThan", resFilterCaps);
        }
    }

    private void addNameFilterOGC(ComparisonOperators spatialOps, String nameFES, String nameOGC, Capabilities resFilterCaps) {
        if (null != spatialOps.getOperator(nameFES)) {
            Loggers.trace("WFS 2.0 capabilities states the scalar operator " + nameFES + ". ", "Assuming it is " + nameOGC + " and adding " + nameOGC + " as a supported filter type");
            resFilterCaps.addName(nameOGC);
        }
    }

    protected Filter simplify(Filter filter) {
        if (Filter.INCLUDE.equals(filter) || Filter.EXCLUDE.equals(filter)) {
            return filter;
        }
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        filter = (Filter)filter.accept((FilterVisitor)simplifier, null);
        return filter;
    }

    @Override
    public URL buildUrlGET(WFSRequest request) {
        Map<String, String> requestParams;
        WFSOperationType operation = request.getOperation();
        String encoding = "UTF-8";
        switch (operation) {
            case GET_FEATURE: {
                requestParams = this.buildGetFeatureParametersForGET((GetFeatureRequest)request);
                encoding = Charset.defaultCharset().name();
                break;
            }
            case DESCRIBE_FEATURETYPE: {
                requestParams = this.buildDescribeFeatureTypeParametersForGET((DescribeFeatureTypeRequest)request);
                break;
            }
            case DESCRIBE_STORED_QUERIES: {
                requestParams = this.buildDescribeStoredQueriesParametersForGET((DescribeStoredQueriesRequest)request);
                break;
            }
            case LIST_STORED_QUERIES: {
                requestParams = this.buildListStoredQueriesParametersForGET((ListStoredQueriesRequest)request);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        URL baseUrl = this.getOperationURL(operation, HttpMethod.GET);
        URL finalURL = URIs.buildURL(baseUrl, requestParams, encoding);
        Loggers.requestDebug(new Object[]{"Built GET request for ", operation, ": ", finalURL});
        return finalURL;
    }

    @Override
    public String getPostContentType(WFSRequest wfsRequest) {
        WFSOperationType operation = wfsRequest.getOperation();
        if (WFSOperationType.DESCRIBE_FEATURETYPE.equals((Object)operation) || WFSOperationType.DESCRIBE_STORED_QUERIES.equals((Object)operation) || WFSOperationType.LIST_STORED_QUERIES.equals((Object)operation)) {
            return "text/xml";
        }
        String defaultOutputFormat = this.getDefaultOutputFormat(operation);
        return defaultOutputFormat;
    }

    @Override
    public InputStream getPostContents(WFSRequest request) throws IOException {
        EObject requestObject = switch (request.getOperation()) {
            case WFSOperationType.DESCRIBE_FEATURETYPE -> this.createDescribeFeatureTypeRequestPost((DescribeFeatureTypeRequest)request);
            case WFSOperationType.DESCRIBE_STORED_QUERIES -> this.createDescribeStoredQueriesRequestPost((DescribeStoredQueriesRequest)request);
            case WFSOperationType.GET_FEATURE -> this.createGetFeatureRequestPost((GetFeatureRequest)request);
            case WFSOperationType.LIST_STORED_QUERIES -> this.createListStoredQueriesRequestPost((ListStoredQueriesRequest)request);
            case WFSOperationType.TRANSACTION -> this.createTransactionRequest((TransactionRequest)request);
            default -> throw new UnsupportedOperationException("not yet implemented for " + String.valueOf((Object)request.getOperation()));
        };
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder encoder = this.prepareEncoder(request);
        QName opName = this.getOperationName(request.getOperation());
        encoder.encode((Object)requestObject, opName, (OutputStream)out);
        Loggers.requestTrace(new Object[]{"Encoded ", request.getOperation(), " request: ", out});
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public Map<QName, Class<?>> getFieldTypeMappings() {
        return null;
    }
}

