/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wfs20.WFSCapabilitiesType;
import org.eclipse.emf.ecore.EObject;
import org.geotools.api.data.DataSourceException;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class GetCapabilitiesResponse
extends org.geotools.data.ows.GetCapabilitiesResponse {
    private WFSGetCapabilities capabilities;
    private static Logger LOGGER = Logging.getLogger(GetCapabilitiesResponse.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetCapabilitiesResponse(HTTPResponse response, EntityResolver entityResolver) throws IOException, ServiceException {
        super(response);
        LOGGER.finer("Parsing GetCapabilities response");
        try {
            Document rawDocument;
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                builderFactory.setValidating(false);
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                if (entityResolver != null) {
                    documentBuilder.setEntityResolver(entityResolver);
                }
                rawDocument = documentBuilder.parse(response.getResponseStream());
            }
            catch (Exception e) {
                throw new IOException("Error parsing capabilities document: " + e.getMessage(), e);
            }
            List<Configuration> tryConfigs = Arrays.asList(AbstractWFSStrategy.WFS_2_0_CONFIGURATION, AbstractWFSStrategy.WFS_1_1_CONFIGURATION, AbstractWFSStrategy.WFS_1_0_CAPABILITIES_CONFIGURATION);
            String versionAtt = rawDocument.getDocumentElement().getAttribute("version");
            Version version = null;
            if (null != versionAtt) {
                version = new Version(versionAtt);
                if (Versions.v1_0_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_1_0_CAPABILITIES_CONFIGURATION);
                } else if (Versions.v1_1_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_1_1_CONFIGURATION);
                } else if (Versions.v2_0_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_2_0_CONFIGURATION);
                }
            }
            EObject parsedCapabilities = null;
            for (Configuration wfsConfig : tryConfigs) {
                try {
                    parsedCapabilities = this.parseCapabilities(rawDocument, wfsConfig);
                    if (parsedCapabilities == null) continue;
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Couldn't use configuration:" + wfsConfig.getClass().getName(), e);
                }
            }
            if (null == parsedCapabilities) {
                throw new IllegalStateException("Unable to parse GetCapabilities document");
            }
            this.capabilities = WFSGetCapabilities.create(parsedCapabilities, rawDocument);
        }
        finally {
            response.dispose();
        }
    }

    private EObject parseCapabilities(Document document, Configuration wfsConfig) throws IOException {
        Object parsed;
        DOMParser parser = new DOMParser(wfsConfig, document);
        try {
            parsed = parser.parse();
        }
        catch (Exception e) {
            throw new DataSourceException("Exception parsing WFS capabilities", (Throwable)e);
        }
        if (parsed == null) {
            throw new DataSourceException("WFS capabilities was not parsed");
        }
        if (!(parsed instanceof net.opengis.wfs.WFSCapabilitiesType) && !(parsed instanceof WFSCapabilitiesType)) {
            throw new DataSourceException("Expected WFS Capabilities, got " + String.valueOf(parsed));
        }
        EObject object = (EObject)parsed;
        return object;
    }

    public WFSGetCapabilities getCapabilities() {
        return this.capabilities;
    }
}

