/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.util.factory.FactoryNotFoundException;

public class WFSExtensions {
    private static volatile Set<WFSResponseFactory> registry;

    public static WFSResponseFactory findResponseFactory(WFSRequest originatingRequest, String contentType) {
        return WFSExtensions.getServiceProviders().filter(factory -> factory.isAvailable() && factory.canProcess(originatingRequest, contentType)).findFirst().orElseThrow(() -> new FactoryNotFoundException("Can't find a response parser factory for " + String.valueOf((Object)originatingRequest.getOperation()) + "/'" + contentType + "'"));
    }

    public static List<WFSResponseFactory> findResponseFactories(WFSOperationType operation) {
        return WFSExtensions.getServiceProviders().filter(factory -> factory.isAvailable() && factory.canProcess(operation)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Stream<WFSResponseFactory> getServiceProviders() {
        if (registry != null) return registry.stream();
        Class<WFSExtensions> clazz = WFSExtensions.class;
        synchronized (WFSExtensions.class) {
            if (registry != null) return registry.stream();
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader tempClassLoader = WFSDataStoreFactory.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(tempClassLoader);
                Iterator<WFSResponseFactory> providers = ServiceLoader.load(WFSResponseFactory.class).iterator();
                HashSet<WFSResponseFactory> tmp = new HashSet<WFSResponseFactory>();
                while (providers.hasNext()) {
                    WFSResponseFactory provider = providers.next();
                    tmp.add(provider);
                }
                registry = tmp;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry.stream();
        }
    }
}

