/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gml.stream.XmlStreamGeometryReader;
import org.geotools.gml3.GML;
import org.geotools.util.Converters;
import org.geotools.wfs.WFS;
import org.locationtech.jts.geom.GeometryFactory;

public class XmlSimpleFeatureParser
implements GetParser<SimpleFeature> {
    private static final Logger LOGGER = Loggers.RESPONSES;
    private InputStream inputStream;
    private XMLStreamReader parser;
    private XmlStreamGeometryReader geometryReader;
    private SimpleFeatureType targetType;
    private SimpleFeatureBuilder builder;
    final String featureNamespace;
    final String featureName;
    private final Map<String, AttributeDescriptor> expectedProperties;
    private int numberOfFeatures = -1;

    public XmlSimpleFeatureParser(InputStream getFeatureResponseStream, SimpleFeatureType targetType, QName featureDescriptorName, String axisOrder) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureNamespace = featureDescriptorName.getNamespaceURI();
        this.featureName = featureDescriptorName.getLocalPart();
        this.targetType = targetType;
        this.builder = new SimpleFeatureBuilder(targetType);
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.parser = factory.createXMLStreamReader(this.inputStream, "UTF-8");
            this.geometryReader = new XmlStreamGeometryReader(this.parser, new GeometryFactory());
            this.geometryReader.setInvertAxisNeeded(crs -> WFSConfig.invertAxisNeeded(axisOrder, crs));
            while (this.parser.hasNext() && 1 != this.parser.next()) {
            }
            this.parser.require(1, null, WFS.FeatureCollection.getLocalPart());
            String nof = this.parser.getAttributeValue(null, "numberOfFeatures");
            if (nof != null) {
                try {
                    this.numberOfFeatures = Integer.valueOf(nof);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Can't parse numberOfFeatures out of " + nof);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new DataSourceException((Throwable)e);
        }
        this.expectedProperties = new TreeMap<String, AttributeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (AttributeDescriptor desc : targetType.getAttributeDescriptors()) {
            this.expectedProperties.put(desc.getLocalName(), desc);
        }
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
        if (null != geometryFactory) {
            this.geometryReader.setGeometryFactory(geometryFactory);
        }
    }

    @Override
    public FeatureType getFeatureType() {
        return this.targetType;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.parser.close();
                this.parser = null;
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (XMLStreamException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
    }

    @Override
    public SimpleFeature parse() throws IOException {
        String fid;
        try {
            fid = this.seekFeature();
            if (fid == null) {
                return null;
            }
            while (true) {
                int tagType;
                if (8 == (tagType = this.parser.next())) {
                    this.close();
                    return null;
                }
                if (2 != tagType || !this.featureNamespace.equals(this.parser.getNamespaceURI()) || !this.featureName.equals(this.parser.getLocalName())) {
                    AttributeDescriptor descriptor;
                    if (1 != tagType || (descriptor = this.expectedProperties.get(this.parser.getLocalName())) == null) continue;
                    Object attributeValue = this.parseAttributeValue();
                    this.builder.set(descriptor.getLocalName(), attributeValue);
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new DataSourceException((Throwable)e);
        }
        SimpleFeature feature = this.builder.buildFeature(fid);
        return feature;
    }

    private Object parseAttributeValue() throws XMLStreamException, IOException {
        Object parsedValue;
        String name = this.parser.getLocalName();
        AttributeDescriptor attribute = this.expectedProperties.get(name);
        AttributeType type = attribute.getType();
        if (type instanceof GeometryType) {
            this.parser.nextTag();
            try {
                parsedValue = this.geometryReader.readGeometry();
            }
            catch (FactoryException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            String rawTextValue = this.parser.getElementText();
            Class binding = type.getBinding();
            parsedValue = Converters.convert((Object)rawTextValue, (Class)binding);
        }
        return parsedValue;
    }

    private String seekFeature() throws IOException, XMLStreamException {
        while (true) {
            int tagType;
            if ((tagType = this.parser.next()) == 8) {
                this.close();
                return null;
            }
            if (1 != tagType || 1 != tagType) continue;
            String namespace = this.parser.getNamespaceURI();
            String name = this.parser.getLocalName();
            if (this.featureNamespace.equals(namespace) && this.featureName.equals(name)) break;
        }
        String featureId = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "fid");
        }
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "id");
        }
        return featureId;
    }
}

