/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.OnlineResourceType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.wfs20.WFSCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.wfs.WFSServiceInfo;

public final class Capabilities200ServiceInfo
implements WFSServiceInfo {
    private final WFSCapabilitiesType capabilities;
    private final URI schemaUri;
    private final URI getCapsUrl;

    public Capabilities200ServiceInfo(String schemaUri, URL getCapsUrl, WFSCapabilitiesType capabilities) {
        try {
            this.getCapsUrl = getCapsUrl.toURI();
            this.schemaUri = new URI(schemaUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.capabilities = capabilities;
    }

    public String getDescription() {
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        if (serviceIdentification == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object line : serviceIdentification.getAbstract()) {
            if (line instanceof LanguageStringType) {
                LanguageStringType type = (LanguageStringType)line;
                sb.append(type.getValue());
                continue;
            }
            sb.append(line);
        }
        return sb.toString();
    }

    public Icon getIcon() {
        return null;
    }

    public Set<String> getKeywords() {
        EList keywords;
        HashSet<String> kws = new HashSet<String>();
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        if (serviceIdentification != null && (keywords = serviceIdentification.getKeywords()) != null) {
            for (KeywordsType k : keywords) {
                EList keywordStrings = k.getKeyword();
                for (LanguageStringType s : keywordStrings) {
                    kws.add(s.getValue());
                }
            }
            kws.remove(null);
        }
        return kws;
    }

    public URI getPublisher() {
        ServiceProviderType serviceProvider = this.capabilities.getServiceProvider();
        if (null == serviceProvider) {
            return null;
        }
        OnlineResourceType providerSite = serviceProvider.getProviderSite();
        if (null == providerSite) {
            return null;
        }
        String href = providerSite.getHref();
        try {
            return href == null ? null : new URI(href);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getSchema() {
        return this.schemaUri;
    }

    public URI getSource() {
        return this.getCapsUrl;
    }

    public String getTitle() {
        ServiceIdentificationType serviceIdentification = this.capabilities.getServiceIdentification();
        if (serviceIdentification == null || serviceIdentification.getTitle() == null || serviceIdentification.getTitle().isEmpty()) {
            return null;
        }
        return ((LanguageStringType)serviceIdentification.getTitle().get(0)).getValue();
    }

    @Override
    public String getVersion() {
        return this.capabilities.getVersion();
    }
}

