/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import org.geotools.api.style.Extent;
import org.geotools.api.style.StyleFactory;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.factory.CommonFactoryFinder;

public class ExtentBuilder<P>
implements Builder<Extent> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private String name;
    private String value;

    public ExtentBuilder() {
        this(null);
    }

    public ExtentBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public Extent build() {
        if (this.unset) {
            return null;
        }
        Extent extent = this.sf.createExtent(this.name, this.value);
        return extent;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public ExtentBuilder<P> reset() {
        this.name = null;
        this.value = null;
        this.unset = false;
        return this;
    }

    @Override
    public ExtentBuilder<P> reset(Extent extent) {
        if (extent == null) {
            return this.reset();
        }
        this.value = extent.getValue();
        this.name = extent.getName();
        this.unset = false;
        return this;
    }

    @Override
    public ExtentBuilder<P> unset() {
        this.name = null;
        this.value = null;
        this.unset = true;
        return this;
    }
}

