/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.Symbol;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.AnchorPointBuilder;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.brewer.styling.builder.DisplacementBuilder;
import org.geotools.brewer.styling.builder.ExternalGraphicBuilder;
import org.geotools.brewer.styling.builder.MarkBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;

public class GraphicLegendBuilder
extends AbstractStyleBuilder<GraphicLegend> {
    private List<Builder<? extends Symbol>> symbols = new ArrayList<Builder<? extends Symbol>>();
    private Expression opacity;
    private Expression size;
    private Expression rotation;
    private AnchorPointBuilder anchorPoint = new AnchorPointBuilder(this, 0.0, 0.0).unset();
    private DisplacementBuilder displacement = new DisplacementBuilder(this).unset();

    public GraphicLegendBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public GraphicLegendBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    @Override
    public GraphicLegend build() {
        if (this.unset) {
            return null;
        }
        if (this.symbols.isEmpty()) {
            this.symbols.add(new MarkBuilder(this));
        }
        ArrayList<GraphicalSymbol> list = new ArrayList<GraphicalSymbol>();
        for (Builder<? extends Symbol> symbol : this.symbols) {
            list.add((GraphicalSymbol)symbol.build());
        }
        GraphicLegend graphic = this.sf.graphicLegend(list, this.opacity, this.size, this.rotation, this.anchorPoint.build(), this.displacement.build());
        return graphic;
    }

    public AnchorPointBuilder anchor() {
        this.unset = false;
        return this.anchorPoint;
    }

    public DisplacementBuilder displacement() {
        this.unset = false;
        return this.displacement;
    }

    public GraphicLegendBuilder opacity(Expression opacity) {
        this.opacity = opacity;
        return this;
    }

    public GraphicLegendBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public GraphicLegendBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public GraphicLegendBuilder size(Expression size) {
        this.size = size;
        return this;
    }

    public GraphicLegendBuilder size(double size) {
        return this.size(this.literal(size));
    }

    public GraphicLegendBuilder size(String cqlExpression) {
        return this.size(this.cqlExpression(cqlExpression));
    }

    public GraphicLegendBuilder rotation(Expression rotation) {
        this.rotation = rotation;
        return this;
    }

    public GraphicLegendBuilder rotation(double rotation) {
        return this.rotation(this.literal(rotation));
    }

    public GraphicLegendBuilder rotation(String cqlExpression) {
        return this.rotation(this.cqlExpression(cqlExpression));
    }

    public GraphicLegendBuilder reset() {
        this.opacity = this.literal(1);
        this.size = this.literal(16);
        this.rotation = this.literal(0);
        this.anchorPoint.reset();
        this.displacement.reset();
        this.symbols.clear();
        this.unset = false;
        return this;
    }

    public GraphicLegendBuilder reset(GraphicLegend graphic) {
        if (graphic == null) {
            return this.unset();
        }
        this.opacity = graphic.getOpacity();
        this.size = graphic.getSize();
        this.rotation = graphic.getRotation();
        this.anchorPoint.reset(graphic.getAnchorPoint());
        this.displacement.reset(graphic.getDisplacement());
        this.symbols.clear();
        for (GraphicalSymbol symbol : graphic.graphicalSymbols()) {
            AbstractStyleBuilder builder;
            if (symbol instanceof Mark) {
                Mark mark = (Mark)symbol;
                builder = new MarkBuilder(this).reset(mark);
            } else if (symbol instanceof ExternalGraphic) {
                ExternalGraphic externalGraphic = (ExternalGraphic)symbol;
                builder = new ExternalGraphicBuilder(this).reset(externalGraphic);
            } else {
                throw new IllegalArgumentException("Unrecognized symbol type: " + String.valueOf(symbol.getClass()));
            }
            this.symbols.add(builder);
        }
        this.unset = false;
        return this;
    }

    @Override
    public GraphicLegendBuilder unset() {
        return (GraphicLegendBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().legend().init(this);
    }
}

