/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.filter.expression;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.brewer.styling.filter.expression.AddBuilder;
import org.geotools.brewer.styling.filter.expression.DivideBuilder;
import org.geotools.brewer.styling.filter.expression.FunctionBuilder;
import org.geotools.brewer.styling.filter.expression.LiteralBuilder;
import org.geotools.brewer.styling.filter.expression.MultiplyBuilder;
import org.geotools.brewer.styling.filter.expression.NilBuilder;
import org.geotools.brewer.styling.filter.expression.PropertyNameBuilder;
import org.geotools.brewer.styling.filter.expression.SubtractBuilder;
import org.geotools.factory.CommonFactoryFinder;

public class ExpressionBuilder
implements Builder<Expression> {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected boolean unset = false;
    protected Builder<? extends Expression> delegate = new NilBuilder();

    public ExpressionBuilder() {
        this.reset();
    }

    public ExpressionBuilder(Expression expr) {
        this.reset(expr);
    }

    public LiteralBuilder literal() {
        this.delegate = new LiteralBuilder();
        this.unset = false;
        return (LiteralBuilder)this.delegate;
    }

    public Builder<?> literal(Object literal) {
        this.delegate = new LiteralBuilder().value(literal);
        this.unset = false;
        return this;
    }

    public AddBuilder add() {
        this.delegate = new AddBuilder();
        this.unset = false;
        return (AddBuilder)this.delegate;
    }

    public MultiplyBuilder multiply() {
        this.delegate = new MultiplyBuilder();
        this.unset = false;
        return (MultiplyBuilder)this.delegate;
    }

    public DivideBuilder divide() {
        this.delegate = new DivideBuilder();
        this.unset = false;
        return (DivideBuilder)this.delegate;
    }

    public SubtractBuilder subtract() {
        this.delegate = new SubtractBuilder();
        this.unset = false;
        return (SubtractBuilder)this.delegate;
    }

    public PropertyNameBuilder property() {
        this.delegate = new PropertyNameBuilder();
        this.unset = false;
        return (PropertyNameBuilder)this.delegate;
    }

    public Builder<?> property(String xpath) {
        this.delegate = new PropertyNameBuilder().property(xpath);
        this.unset = false;
        return this;
    }

    public FunctionBuilder function() {
        this.delegate = new FunctionBuilder();
        this.unset = false;
        return (FunctionBuilder)this.delegate;
    }

    public FunctionBuilder function(String name) {
        this.delegate = new FunctionBuilder().name(name);
        this.unset = false;
        return (FunctionBuilder)this.delegate;
    }

    @Override
    public Expression build() {
        if (this.unset) {
            return null;
        }
        return this.delegate.build();
    }

    public ExpressionBuilder reset() {
        this.delegate = new NilBuilder();
        this.unset = false;
        return this;
    }

    public ExpressionBuilder reset(Expression original) {
        if (original == null) {
            return this.unset();
        }
        this.unset = false;
        if (original instanceof Literal) {
            Literal literal = (Literal)original;
            this.delegate = new LiteralBuilder(literal);
        } else if (original instanceof PropertyName) {
            PropertyName name = (PropertyName)original;
            this.delegate = new PropertyNameBuilder(name);
        } else if (original instanceof Function) {
            Function function = (Function)original;
            this.delegate = new FunctionBuilder(function);
        } else if (original instanceof Add) {
            Add add = (Add)original;
            this.delegate = new AddBuilder(add);
        } else if (original instanceof Divide) {
            Divide divide = (Divide)original;
            this.delegate = new DivideBuilder(divide);
        } else if (original instanceof Multiply) {
            Multiply multiply = (Multiply)original;
            this.delegate = new MultiplyBuilder(multiply);
        } else if (original instanceof Subtract) {
            Subtract subtract = (Subtract)original;
            this.delegate = new SubtractBuilder(subtract);
        } else {
            this.delegate = new NilBuilder();
        }
        return this;
    }

    public ExpressionBuilder unset() {
        this.unset = true;
        this.delegate = new NilBuilder();
        return this;
    }

    public boolean isUnset() {
        return this.unset;
    }
}

