/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.CacheCleaner;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;

class CacheCleanerTask
implements Runnable {
    static final Logger LOG = Logging.getLogger((String)CacheCleanerTask.class.getName());
    private final Map<String, Future<?>> perLayerRunningCleanUps;
    private Future<?> globalCleanUpTask;
    private ExecutorService cleanUpExecutorService;
    private final DiskQuotaMonitor monitor;

    public CacheCleanerTask(DiskQuotaMonitor monitor, ExecutorService executor) {
        this.monitor = monitor;
        this.cleanUpExecutorService = executor;
        this.perLayerRunningCleanUps = new HashMap();
    }

    @Override
    public void run() {
        try {
            this.innerRun();
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "CacheCleanerTask called for shut down", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error running cache diskquota enforcement task", e);
        }
    }

    private void innerRun() throws InterruptedException {
        DiskQuotaConfig quotaConfig = this.monitor.getConfig();
        if (!quotaConfig.isEnabled().booleanValue()) {
            LOG.finer("DiskQuota disabled, ignoring run...");
            return;
        }
        quotaConfig.setLastCleanUpTime(new Date());
        Set<String> allLayerNames = this.monitor.getLayerNames();
        Set<String> configuredLayerNames = quotaConfig.layerNames();
        HashSet<String> globallyManagedLayerNames = new HashSet<String>(allLayerNames);
        globallyManagedLayerNames.removeAll(configuredLayerNames);
        for (String layerName : configuredLayerNames) {
            if (this.monitor.isCacheInfoBuilderRunning(layerName)) {
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("Cache information is still being gathered for layer '" + layerName + "'. Skipping quota enforcement task for this layer.");
                continue;
            }
            Future<?> runningCleanup = this.perLayerRunningCleanUps.get(layerName);
            if (runningCleanup != null && !runningCleanup.isDone()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Cache clean up task still running for layer '" + layerName + "'. Ignoring it for this run.");
                continue;
            }
            LayerQuota definedQuotaForLayer = quotaConfig.layerQuota(layerName);
            ExpirationPolicy policy = definedQuotaForLayer.getExpirationPolicyName();
            Quota quota = definedQuotaForLayer.getQuota();
            Quota usedQuota = this.monitor.getUsedQuotaByLayerName(layerName);
            Quota excedent = usedQuota.difference(quota);
            if (excedent.getBytes().compareTo(BigInteger.ZERO) <= 0) continue;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Layer '" + layerName + "' exceeds its quota of " + quota.toNiceString() + " by " + excedent.toNiceString() + ". Currently used: " + usedQuota.toNiceString() + ". Clean up task will be performed using expiration policy " + String.valueOf((Object)policy));
            }
            Set<String> layerNames = Collections.singleton(layerName);
            CacheCleaner.QuotaResolver quotaResolver = this.monitor.newLayerQuotaResolver(layerName);
            LayerQuotaEnforcementTask task = new LayerQuotaEnforcementTask(layerNames, quotaResolver, this.monitor);
            Future<Object> future = this.cleanUpExecutorService.submit(task);
            this.perLayerRunningCleanUps.put(layerName, future);
        }
        if (!globallyManagedLayerNames.isEmpty()) {
            ExpirationPolicy globalExpirationPolicy = quotaConfig.getGlobalExpirationPolicyName();
            if (globalExpirationPolicy == null) {
                return;
            }
            Quota globalQuota = quotaConfig.getGlobalQuota();
            if (globalQuota == null) {
                LOG.info("There's not a global disk quota configured. The following layers will not be checked for excess of disk usage: " + String.valueOf(globallyManagedLayerNames));
                return;
            }
            if (this.globalCleanUpTask != null && !this.globalCleanUpTask.isDone()) {
                LOG.fine("Global cache quota enforcement task still running, avoiding issueing a new one...");
                return;
            }
            Quota globalUsedQuota = this.monitor.getGloballyUsedQuota();
            Quota excedent = globalUsedQuota.difference(globalQuota);
            if (excedent.getBytes().compareTo(BigInteger.ZERO) > 0) {
                LOG.fine("Submitting global cache quota enforcement task");
                CacheCleaner.QuotaResolver quotaResolver = this.monitor.newGlobalQuotaResolver();
                LayerQuotaEnforcementTask task = new LayerQuotaEnforcementTask(globallyManagedLayerNames, quotaResolver, this.monitor);
                this.globalCleanUpTask = this.cleanUpExecutorService.submit(task);
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Won't launch global quota enforcement task, " + globalUsedQuota.toNiceString() + " used out of " + globalQuota.toNiceString() + " configured for the whole cache size.");
            }
        }
    }

    private static class LayerQuotaEnforcementTask
    implements Callable<Object> {
        private final Set<String> layerNames;
        private final CacheCleaner.QuotaResolver quotaResolver;
        private final DiskQuotaMonitor monitor;

        public LayerQuotaEnforcementTask(Set<String> layerNames, CacheCleaner.QuotaResolver quotaResolver, DiskQuotaMonitor monitor) {
            this.layerNames = layerNames;
            this.quotaResolver = quotaResolver;
            this.monitor = monitor;
        }

        @Override
        public Object call() throws Exception {
            try {
                this.monitor.expireByLayerNames(this.layerNames, this.quotaResolver);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Layer quota enforcement task terminated prematurely");
                return null;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception expiring tiles for " + String.valueOf(this.layerNames), e);
                throw e;
            }
            return null;
        }
    }
}

