/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.util.Assert;

public class ConfigLoader {
    private static final Logger log = Logging.getLogger((String)ConfigLoader.class.getName());
    private static final String CONFIGURATION_FILE_NAME = "geowebcache-diskquota.xml";
    private final TileLayerDispatcher tileLayerDispatcher;
    private final ConfigurationResourceProvider resourceProvider;
    private final DefaultStorageFinder storageFinder;

    public ConfigLoader(DefaultStorageFinder storageFinder, ApplicationContextProvider contextProvider, TileLayerDispatcher tld) throws ConfigurationException {
        this((ConfigurationResourceProvider)new XMLFileResourceProvider(CONFIGURATION_FILE_NAME, contextProvider, null, storageFinder), storageFinder, tld);
    }

    public ConfigLoader(ConfigurationResourceProvider resourceProvider, DefaultStorageFinder storageFinder, TileLayerDispatcher tld) throws ConfigurationException {
        this.resourceProvider = resourceProvider;
        this.storageFinder = storageFinder;
        this.tileLayerDispatcher = tld;
    }

    public void saveConfig(DiskQuotaConfig config) throws IOException, ConfigurationException {
        if (!this.resourceProvider.hasOutput()) {
            log.log(Level.SEVERE, "Unable to save DiskQuota to resource :" + this.resourceProvider.getLocation());
            return;
        }
        XStream xStream = ConfigLoader.getConfiguredXStream((XStream)new GeoWebCacheXStream());
        log.fine("Saving disk quota config to " + this.resourceProvider.getLocation());
        try (OutputStream configOut = this.resourceProvider.out();){
            xStream.toXML((Object)config, (Writer)new OutputStreamWriter(configOut, StandardCharsets.UTF_8));
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Error saving DiskQuota config to file :" + this.resourceProvider.getLocation());
        }
    }

    public DiskQuotaConfig loadConfig() throws IOException, ConfigurationException {
        DiskQuotaConfig quotaConfig = null;
        if (this.resourceProvider.hasInput()) {
            log.config("Quota config is: " + this.resourceProvider.getLocation());
            try (InputStream configIn = this.resourceProvider.in();){
                quotaConfig = this.loadConfiguration(configIn);
                if (null == quotaConfig) {
                    throw new ConfigurationException("Couldn't parse configuration file " + this.resourceProvider.getLocation());
                }
            }
            catch (IOException | RuntimeException e) {
                log.log(Level.SEVERE, "Error loading DiskQuota configuration from " + this.resourceProvider.getLocation() + ": " + e.getMessage() + ". Deferring to a default (disabled) configuration", e);
            }
        } else {
            log.config("DiskQuota configuration is not readable: " + this.resourceProvider.getLocation());
        }
        if (quotaConfig == null) {
            quotaConfig = new DiskQuotaConfig();
        }
        quotaConfig.setDefaults();
        this.validateConfig(quotaConfig);
        return quotaConfig;
    }

    private void validateConfig(DiskQuotaConfig quotaConfig) throws ConfigurationException {
        int cacheCleanUpFrequency = quotaConfig.getCacheCleanUpFrequency();
        if (cacheCleanUpFrequency <= 0) {
            throw new ConfigurationException("cacheCleanUpFrequency shall be a positive integer");
        }
        TimeUnit cacheCleanUpUnits = quotaConfig.getCacheCleanUpUnits();
        if (cacheCleanUpUnits == null) {
            throw new ConfigurationException("cacheCleanUpUnits shall be specified. Expected one of SECONDS, MINUTES, HOURS, DAYS. Got null");
        }
        int maxConcurrentCleanUps = quotaConfig.getMaxConcurrentCleanUps();
        if (maxConcurrentCleanUps <= 0) {
            throw new ConfigurationException("maxConcurrentCleanUps shall be specified as a positive integer");
        }
        if (null != quotaConfig.getLayerQuotas()) {
            for (LayerQuota lq : new ArrayList<LayerQuota>(quotaConfig.getLayerQuotas())) {
                if (null == lq.getQuota()) {
                    log.info("Configured quota for layer " + lq.getLayer() + " is null. Discarding it to be attached to the global quota");
                    quotaConfig.remove(lq);
                    continue;
                }
                this.validateLayerQuota(quotaConfig, lq);
            }
        }
    }

    private void validateLayerQuota(DiskQuotaConfig quotaConfig, LayerQuota lq) throws ConfigurationException {
        String layer = lq.getLayer();
        try {
            this.tileLayerDispatcher.getTileLayer(layer);
        }
        catch (GeoWebCacheException e) {
            log.log(Level.SEVERE, "LayerQuota configuration error: layer " + layer + " does not exist. Removing quota from runtime configuration.", e);
            quotaConfig.remove(lq);
        }
        ExpirationPolicy expirationPolicyName = lq.getExpirationPolicyName();
        if (expirationPolicyName == null) {
            if (lq.getQuota() != null) {
                throw new ConfigurationException("Layer " + lq.getLayer() + " has no expiration policy, but does have a quota defined. Either both or neither should be present");
            }
            return;
        }
        Quota quota = lq.getQuota();
        try {
            this.validateQuota(quota);
        }
        catch (ConfigurationException e) {
            log.log(Level.SEVERE, "LayerQuota configuration error for layer " + layer + ". Error message is: " + e.getMessage() + ". Quota removed from runtime configuration.");
            quotaConfig.remove(lq);
        }
    }

    private void validateQuota(Quota quota) throws ConfigurationException {
        if (quota == null) {
            throw new IllegalArgumentException("No quota defined");
        }
        BigInteger limit = quota.getBytes();
        if (limit.compareTo(BigInteger.ZERO) < 0) {
            throw new ConfigurationException("Limit shall be >= 0: " + String.valueOf(limit) + ". " + String.valueOf(quota));
        }
        log.fine("Quota validated: " + String.valueOf(quota));
    }

    private DiskQuotaConfig loadConfiguration(InputStream configStream) throws XStreamException {
        DiskQuotaConfig diskQuotaConfig;
        XStream xstream = ConfigLoader.getConfiguredXStream((XStream)new GeoWebCacheXStream());
        InputStreamReader reader = new InputStreamReader(configStream, StandardCharsets.UTF_8);
        try {
            DiskQuotaConfig fromXML;
            diskQuotaConfig = fromXML = ConfigLoader.loadConfiguration(reader, xstream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return diskQuotaConfig;
    }

    public static DiskQuotaConfig loadConfiguration(Reader reader, XStream xstream) {
        DiskQuotaConfig fromXML = (DiskQuotaConfig)xstream.fromXML(reader);
        GeoWebCacheEnvironment gwcEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
        if (gwcEnvironment != null && gwcEnvironment.isAllowEnvParametrization()) {
            fromXML.setQuotaStore((String)gwcEnvironment.resolveValue((Object)fromXML.getQuotaStore()));
        }
        return fromXML;
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.allowTypesByWildcard(new String[]{"org.geowebcache.**"});
        xs.setMode(1001);
        xs.alias("gwcQuotaConfiguration", DiskQuotaConfig.class);
        xs.alias("layerQuotas", List.class);
        xs.alias("LayerQuota", LayerQuota.class);
        xs.alias("Quota", Quota.class);
        xs.registerConverter((Converter)new QuotaXSTreamConverter());
        return xs;
    }

    public OutputStream getStorageOutputStream(String ... fileNameRelPath) throws IOException, ConfigurationException {
        File rootCacheDir = this.getFileStorageDir(fileNameRelPath);
        String fileName = fileNameRelPath[fileNameRelPath.length - 1];
        File configFile = new File(rootCacheDir, fileName);
        return new FileOutputStream(configFile);
    }

    public InputStream getStorageInputStream(String ... fileNameRelPath) throws IOException, ConfigurationException {
        File rootCacheDir = this.getFileStorageDir(fileNameRelPath);
        String fileName = fileNameRelPath[fileNameRelPath.length - 1];
        File configFile = new File(rootCacheDir, fileName);
        return new FileInputStream(configFile);
    }

    private File getFileStorageDir(String[] fileNameRelPath) throws ConfigurationException {
        File parentDir = this.getRootCacheDir();
        for (int i = 0; i < fileNameRelPath.length - 1; ++i) {
            parentDir = new File(parentDir, fileNameRelPath[i]);
        }
        parentDir.mkdirs();
        return parentDir;
    }

    public File getRootCacheDir() throws ConfigurationException {
        return new File(this.storageFinder.getDefaultPath());
    }

    private static final class QuotaXSTreamConverter
    implements Converter {
        private QuotaXSTreamConverter() {
        }

        public boolean canConvert(Class type) {
            return Quota.class.equals((Object)type);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Quota quota = new Quota();
            reader.moveDown();
            String nodeName = reader.getNodeName();
            Assert.isTrue((boolean)"value".equals(nodeName), (String)("Expected element name to be 'value' but was " + nodeName + " instead"));
            String nodevalue = reader.getValue();
            double value = Double.parseDouble(nodevalue);
            reader.moveUp();
            reader.moveDown();
            nodeName = reader.getNodeName();
            Assert.isTrue((boolean)"units".equals(nodeName), (String)("Expected to find a units element, but found " + nodeName + " instead"));
            nodevalue = reader.getValue();
            StorageUnit unit = StorageUnit.valueOf(nodevalue);
            reader.moveUp();
            quota.setValue(value, unit);
            return quota;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Quota quota = (Quota)source;
            BigInteger bytes = quota.getBytes();
            StorageUnit unit = StorageUnit.bestFit(bytes);
            BigDecimal value = unit.fromBytes(bytes);
            writer.startNode("value");
            writer.setValue(value.toString());
            writer.endNode();
            writer.startNode("units");
            writer.setValue(unit.toString());
            writer.endNode();
        }
    }
}

