/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.springframework.util.Assert;

public class DiskQuotaConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4376471696761297546L;
    @Deprecated
    static final int DEFAULT_DISK_BLOCK_SIZE = 4096;
    static final int DEFAULT_CLEANUP_FREQUENCY = 10;
    static final TimeUnit DEFAULT_CLEANUP_UNITS = TimeUnit.SECONDS;
    static final int DEFAULT_MAX_CONCURRENT_CLEANUPS = 2;
    static ExpirationPolicy DEFAULT_GLOBAL_POLICY_NAME = ExpirationPolicy.LFU;
    private Boolean enabled;
    private Integer cacheCleanUpFrequency;
    private TimeUnit cacheCleanUpUnits;
    private Integer maxConcurrentCleanUps;
    private ExpirationPolicy globalExpirationPolicyName;
    private Quota globalQuota;
    private transient Date lastCleanUpTime;
    private List<LayerQuota> layerQuotas;
    private String quotaStore;

    public void setDefaults() {
        if (this.enabled == null) {
            this.enabled = Boolean.FALSE;
        }
        if (this.cacheCleanUpFrequency == null) {
            this.cacheCleanUpFrequency = 10;
        }
        if (this.maxConcurrentCleanUps == null) {
            this.maxConcurrentCleanUps = 2;
        }
        if (this.cacheCleanUpUnits == null) {
            this.cacheCleanUpUnits = DEFAULT_CLEANUP_UNITS;
        }
        if (this.globalExpirationPolicyName == null) {
            this.globalExpirationPolicyName = DEFAULT_GLOBAL_POLICY_NAME;
        }
        if (this.globalQuota == null) {
            this.globalQuota = new Quota(500.0, StorageUnit.MiB);
        }
    }

    void setFrom(DiskQuotaConfig other) {
        this.cacheCleanUpFrequency = other.cacheCleanUpFrequency;
        this.cacheCleanUpUnits = other.cacheCleanUpUnits;
        this.enabled = other.enabled;
        this.globalExpirationPolicyName = other.globalExpirationPolicyName;
        this.globalQuota = other.globalQuota;
        this.layerQuotas = other.layerQuotas == null ? null : new ArrayList<LayerQuota>(other.layerQuotas);
        this.maxConcurrentCleanUps = other.maxConcurrentCleanUps;
        this.quotaStore = other.quotaStore;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getCacheCleanUpFrequency() {
        return this.cacheCleanUpFrequency;
    }

    public void setCacheCleanUpFrequency(int cacheCleanUpFrequency) {
        if (cacheCleanUpFrequency < 0) {
            throw new IllegalArgumentException("cacheCleanUpFrequency shall be a positive integer");
        }
        this.cacheCleanUpFrequency = cacheCleanUpFrequency;
    }

    public TimeUnit getCacheCleanUpUnits() {
        return this.cacheCleanUpUnits;
    }

    public void setCacheCleanUpUnits(TimeUnit cacheCleanUpUnit) {
        if (cacheCleanUpUnit == null) {
            throw new IllegalArgumentException("cacheCleanUpUnits can't be null");
        }
        this.cacheCleanUpUnits = cacheCleanUpUnit;
    }

    public List<LayerQuota> getLayerQuotas() {
        return this.layerQuotas == null ? null : new ArrayList<LayerQuota>(this.layerQuotas);
    }

    public void setLayerQuotas(List<LayerQuota> layerQuotas) {
        this.layerQuotas = layerQuotas == null ? null : new ArrayList<LayerQuota>(layerQuotas);
    }

    public void addLayerQuota(LayerQuota quota) {
        Assert.notNull((Object)quota, (String)"Quota must be non null");
        Assert.notNull((Object)quota.getQuota(), (String)"Quota must be non null");
        if (this.layerQuotas == null) {
            this.layerQuotas = new ArrayList<LayerQuota>();
        }
        this.layerQuotas.add(quota);
    }

    public LayerQuota layerQuota(String layerName) {
        if (this.layerQuotas != null) {
            for (LayerQuota lq : this.layerQuotas) {
                if (!lq.getLayer().equals(layerName)) continue;
                return lq;
            }
        }
        return null;
    }

    public void remove(LayerQuota lq) {
        if (this.layerQuotas != null) {
            Iterator<LayerQuota> it = this.layerQuotas.iterator();
            while (it.hasNext()) {
                if (!it.next().getLayer().equals(lq.getLayer())) continue;
                it.remove();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[");
        if (null != this.getLayerQuotas()) {
            for (LayerQuota lq : this.getLayerQuotas()) {
                sb.append("\n\t").append(lq);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public Integer getMaxConcurrentCleanUps() {
        return this.maxConcurrentCleanUps;
    }

    public void setMaxConcurrentCleanUps(int nThreads) {
        if (nThreads <= 0) {
            throw new IllegalArgumentException("maxConcurrentCleanUps shall be a positive integer: " + nThreads);
        }
        this.maxConcurrentCleanUps = nThreads;
    }

    public Quota getGlobalQuota() {
        return this.globalQuota;
    }

    public void setGlobalQuota(Quota newQuota) {
        this.globalQuota = newQuota == null ? null : new Quota(newQuota);
    }

    public ExpirationPolicy getGlobalExpirationPolicyName() {
        return this.globalExpirationPolicyName;
    }

    public void setGlobalExpirationPolicyName(ExpirationPolicy policy) {
        this.globalExpirationPolicyName = policy;
    }

    public void setLastCleanUpTime(Date date) {
        this.lastCleanUpTime = date;
    }

    public Date getLastCleanUpTime() {
        return this.lastCleanUpTime;
    }

    public Set<String> layerNames() {
        HashSet<String> names = new HashSet<String>();
        if (null != this.getLayerQuotas()) {
            for (LayerQuota lq : this.getLayerQuotas()) {
                names.add(lq.getLayer());
            }
        }
        return names;
    }

    public DiskQuotaConfig clone() {
        DiskQuotaConfig clone;
        try {
            clone = (DiskQuotaConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.lastCleanUpTime = this.lastCleanUpTime;
        clone.globalQuota = this.globalQuota == null ? null : new Quota(this.globalQuota);
        clone.layerQuotas = this.layerQuotas == null ? null : new ArrayList<LayerQuota>(this.layerQuotas);
        return clone;
    }

    public String getQuotaStore() {
        return this.quotaStore;
    }

    public void setQuotaStore(String quotaStore) {
        this.quotaStore = quotaStore;
    }
}

