/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.ldap.LDAPAuthenticationProvider;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPSecurityProvider;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geoserver.security.web.auth.AuthenticationProviderPanel;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;
import org.geoserver.web.util.MapModel;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class LDAPAuthProviderPanel
extends AuthenticationProviderPanel<LDAPSecurityServiceConfig> {
    private static final long serialVersionUID = 4772173006888418298L;

    public LDAPAuthProviderPanel(String id, IModel<LDAPSecurityServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("userDnPattern")});
        this.add(new Component[]{new TextField("userFilter")});
        this.add(new Component[]{new TextField("userFormat")});
        boolean useLdapAuth = ((LDAPSecurityServiceConfig)model.getObject()).getUserGroupServiceName() == null;
        this.add(new Component[]{new AjaxCheckBox("useLdapAuthorization", (IModel)new Model((Serializable)Boolean.valueOf(useLdapAuth))){
            private static final long serialVersionUID = 2060279075143716273L;

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)LDAPAuthProviderPanel.this.get("authorizationPanelContainer");
                ((AuthorizationPanel)c.get("authorizationPanel")).resetModel();
                c.remove("authorizationPanel");
                c.add(new Component[]{LDAPAuthProviderPanel.this.createAuthorizationPanel("authorizationPanel", (Boolean)this.getModelObject())});
                target.add(new Component[]{c});
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("authorizationPanelContainer").add(new Component[]{this.createAuthorizationPanel("authorizationPanel", useLdapAuth)}).setOutputMarkupId(true)});
        this.add(new Component[]{new TestLDAPConnectionPanel("testCx")});
    }

    AuthorizationPanel createAuthorizationPanel(String id, boolean useLDAP) {
        return useLDAP ? new LDAPAuthorizationPanel(id) : new UserGroupAuthorizationPanel(id);
    }

    static abstract class AuthorizationPanel
    extends FormComponentPanel<HashMap<String, Object>> {
        private static final long serialVersionUID = -2021795762927385164L;

        public AuthorizationPanel(String id) {
            super(id, (IModel)new Model());
        }

        public abstract void resetModel();
    }

    class TestLDAPConnectionPanel
    extends FormComponentPanel<HashMap<String, Object>> {
        private static final long serialVersionUID = 5433983389877706266L;

        public TestLDAPConnectionPanel(String id) {
            super(id, (IModel)new Model(new HashMap()));
            this.add(new Component[]{new TextField("username", (IModel)new MapModel((Map)this.getModel().getObject(), "username"))});
            this.add(new Component[]{new PasswordTextField("password", (IModel)new MapModel((Map)this.getModel().getObject(), "password")).setRequired(false)});
            this.add(new Component[]{new TestLink().setDefaultFormProcessing(false)});
        }

        private class TestLink
        extends AjaxSubmitLink {
            private static final long serialVersionUID = 2373404292655355758L;

            public TestLink() {
                super("test");
            }

            protected void onSubmit(AjaxRequestTarget target) {
                ((FormComponent)TestLDAPConnectionPanel.this.get("username")).processInput();
                ((FormComponent)TestLDAPConnectionPanel.this.get("password")).processInput();
                ((FormComponent)LDAPAuthProviderPanel.this.get("serverURL")).processInput();
                ((FormComponent)LDAPAuthProviderPanel.this.get("useTLS")).processInput();
                ((FormComponent)LDAPAuthProviderPanel.this.get("userDnPattern")).processInput();
                ((FormComponent)LDAPAuthProviderPanel.this.get("userFilter")).processInput();
                ((FormComponent)LDAPAuthProviderPanel.this.get("userFormat")).processInput();
                String username = (String)((FormComponent)TestLDAPConnectionPanel.this.get("username")).getConvertedInput();
                String password = (String)((FormComponent)TestLDAPConnectionPanel.this.get("password")).getConvertedInput();
                LDAPSecurityServiceConfig ldapConfig = (LDAPSecurityServiceConfig)this.getForm().getModelObject();
                try {
                    this.doTest(ldapConfig, username, password);
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                target.add(new Component[]{this.getPage().get("topFeedback")});
            }

            void doTest(LDAPSecurityServiceConfig ldapConfig, String username, String password) throws AuthenticationException {
                if (ldapConfig.getUserDnPattern() == null && ldapConfig.getUserFilter() == null) {
                    this.error((Serializable)((Object)"Neither user dn pattern or user filter specified"));
                    return;
                }
                LDAPSecurityProvider provider = new LDAPSecurityProvider(LDAPAuthProviderPanel.this.getSecurityManager());
                LDAPAuthenticationProvider authProvider = (LDAPAuthenticationProvider)provider.createAuthenticationProvider((SecurityNamedServiceConfig)ldapConfig);
                Authentication authentication = authProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
                if (authentication == null || !authentication.isAuthenticated()) {
                    throw new AuthenticationException("Cannot authenticate " + username);
                }
                provider.destroy(null);
                this.info((Serializable)new StringResourceModel(LDAPAuthProviderPanel.class.getSimpleName() + ".connectionSuccessful").getObject());
            }
        }
    }

    class LDAPAuthorizationPanel
    extends AuthorizationPanel {
        private static final long serialVersionUID = 7541432269535150812L;
        private static final String USE_NESTED_PARENT_GROUPS = "useNestedParentGroups";
        private static final String MAX_GROUP_SEARCH_LEVEL = "maxGroupSearchLevel";
        private static final String NESTED_GROUP_SEARCH_FILTER = "nestedGroupSearchFilter";
        private static final String NESTED_SEARCH_FIELDS_CONTAINER = "nestedSearchFieldsContainer";

        public LDAPAuthorizationPanel(String id) {
            super(id);
            this.setOutputMarkupId(true);
            this.add(new Component[]{new CheckBox("bindBeforeGroupSearch")});
            this.add(new Component[]{new TextField("adminGroup")});
            this.add(new Component[]{new TextField("groupAdminGroup")});
            this.add(new Component[]{new TextField("groupSearchBase")});
            this.add(new Component[]{new TextField("groupSearchFilter")});
        }

        protected void onInitialize() {
            super.onInitialize();
            this.hierarchicalGroupsinit();
        }

        private void hierarchicalGroupsinit() {
            Optional<LDAPSecurityServiceConfig> useNestedOpt = Optional.of(this).map(x -> {
                try {
                    return x.getForm();
                }
                catch (WicketRuntimeException wicketRuntimeException) {
                    return null;
                }
            }).map(IGenericComponent::getModel).map(IModel::getObject).filter(x -> x instanceof LDAPSecurityServiceConfig).map(x -> (LDAPSecurityServiceConfig)x);
            boolean useNestedActivated = useNestedOpt.map(LDAPBaseSecurityServiceConfig::isUseNestedParentGroups).orElse(false);
            final WebMarkupContainer nestedSearchFieldsContainer = new WebMarkupContainer(NESTED_SEARCH_FIELDS_CONTAINER);
            nestedSearchFieldsContainer.setOutputMarkupPlaceholderTag(true);
            nestedSearchFieldsContainer.setOutputMarkupId(true);
            nestedSearchFieldsContainer.setVisible(useNestedActivated);
            this.add(new Component[]{nestedSearchFieldsContainer});
            TextField maxLevelField = new TextField(MAX_GROUP_SEARCH_LEVEL);
            TextField nestedGroupSearchFilterField = new TextField(NESTED_GROUP_SEARCH_FILTER);
            AjaxCheckBox useNestedCheckbox = new AjaxCheckBox(USE_NESTED_PARENT_GROUPS){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    AjaxCheckBox cb = (AjaxCheckBox)LDAPAuthorizationPanel.this.get(LDAPAuthorizationPanel.USE_NESTED_PARENT_GROUPS);
                    boolean value = (Boolean)cb.getModelObject();
                    nestedSearchFieldsContainer.setVisible(value);
                    target.add(new Component[]{nestedSearchFieldsContainer});
                }
            };
            this.add(new Component[]{useNestedCheckbox});
            nestedSearchFieldsContainer.add(new Component[]{maxLevelField});
            nestedSearchFieldsContainer.add(new Component[]{nestedGroupSearchFilterField});
        }

        @Override
        public void resetModel() {
            this.get("bindBeforeGroupSearch").setDefaultModelObject(null);
            this.get("adminGroup").setDefaultModelObject(null);
            this.get("groupAdminGroup").setDefaultModelObject(null);
            this.get("groupSearchBase").setDefaultModelObject(null);
            this.get("groupSearchFilter").setDefaultModelObject(null);
            this.get(USE_NESTED_PARENT_GROUPS).setDefaultModelObject((Object)false);
        }
    }

    static class UserGroupAuthorizationPanel
    extends AuthorizationPanel {
        private static final long serialVersionUID = 2464048864034610244L;

        public UserGroupAuthorizationPanel(String id) {
            super(id);
            this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName")});
        }

        @Override
        public void resetModel() {
            this.get("userGroupServiceName").setDefaultModelObject(null);
        }
    }
}

