/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkSRGB
extends PngChunkSingle {
    public static final String ID = "sRGB";
    public static final int RENDER_INTENT_Perceptual = 0;
    public static final int RENDER_INTENT_Relative_colorimetric = 1;
    public static final int RENDER_INTENT_Saturation = 2;
    public static final int RENDER_INTENT_Absolute_colorimetric = 3;
    private int intent;

    public PngChunkSRGB(ImageInfo info) {
        super(ID, info);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    public void parseFromRaw(ChunkRaw c) {
        if (c.len != 1) {
            throw new PngjException("bad chunk length " + c);
        }
        this.intent = PngHelperInternal.readInt1fromByte(c.data, 0);
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw c = null;
        c = this.createEmptyChunk(1, true);
        c.data[0] = (byte)this.intent;
        return c;
    }

    public PngChunk cloneForWrite(ImageInfo imgInfo) {
        PngChunkSRGB other = new PngChunkSRGB(imgInfo);
        other.intent = this.intent;
        return other;
    }

    public int getIntent() {
        return this.intent;
    }

    public void setIntent(int intent) {
        this.intent = intent;
    }
}

