/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.convolve;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.KernelImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.convolve.Convolve3x3OpImage;
import org.eclipse.imagen.media.convolve.ConvolveGeneralOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;

public class ConvolveRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock pb, RenderingHints hints) {
        boolean dataTypeOk;
        ImageLayout l = RIFUtil.getImageLayoutHint((RenderingHints)hints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)hints);
        RenderedImage img = pb.getRenderedSource(0);
        KernelImageN kernel = (KernelImageN)pb.getObjectParameter(0);
        ROI roi = (ROI)pb.getObjectParameter(1);
        Range nodata = (Range)pb.getObjectParameter(2);
        double destinationNoData = pb.getDoubleParameter(3);
        boolean skipNoData = (Boolean)pb.getObjectParameter(4);
        kernel = kernel.getRotatedKernel();
        int dataType = pb.getRenderedSource(0).getSampleModel().getDataType();
        boolean bl = dataTypeOk = dataType == 0 || dataType == 2 || dataType == 3;
        if (kernel.getWidth() == 3 && kernel.getHeight() == 3 && kernel.getXOrigin() == 1 && kernel.getYOrigin() == 1 && dataTypeOk) {
            return new Convolve3x3OpImage(img, extender, hints, l, kernel, roi, nodata, destinationNoData, skipNoData);
        }
        return new ConvolveGeneralOpImage(img, extender, hints, l, kernel, roi, nodata, destinationNoData, skipNoData);
    }
}

