/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.convolve;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.KernelImageN;
import org.eclipse.imagen.media.convolve.Convolve3x3OpImage;
import org.eclipse.imagen.media.convolve.ConvolveGeneralOpImage;
import org.eclipse.imagen.media.convolve.SeparableConvolveOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.util.ImageUtil;

public class UnsharpMaskRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        boolean dataTypeOk;
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        KernelImageN unRotatedKernel = ImageUtil.getUnsharpMaskEquivalentKernel((KernelImageN)((KernelImageN)paramBlock.getObjectParameter(0)), (float)paramBlock.getFloatParameter(1));
        KernelImageN kJAI = unRotatedKernel.getRotatedKernel();
        RenderedImage source = paramBlock.getRenderedSource(0);
        int dataType = source.getSampleModel().getDataType();
        boolean bl = dataTypeOk = dataType == 0 || dataType == 2 || dataType == 3;
        if (kJAI.getWidth() == 3 && kJAI.getHeight() == 3 && kJAI.getXOrigin() == 1 && kJAI.getYOrigin() == 1 && dataTypeOk) {
            return new Convolve3x3OpImage(source, extender, renderHints, layout, kJAI, null, null, 0.0, false);
        }
        if (kJAI.isSeparable()) {
            return new SeparableConvolveOpImage(source, extender, renderHints, layout, kJAI, null, null, 0.0, false);
        }
        return new ConvolveGeneralOpImage(source, extender, renderHints, layout, kJAI, null, null, 0.0, false);
    }
}

