/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.imagefunction;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.eclipse.imagen.ImageFunction;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.SourcelessOpImage;
import org.eclipse.imagen.media.imagefunction.ImageFunctionExt;
import org.eclipse.imagen.media.imagefunction.ImageFunctionExtWrapper;
import org.eclipse.imagen.media.imagefunction.JaiI18N;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.util.ImageUtil;

public class ImageFunctionOpImage
extends SourcelessOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    protected ImageFunctionExt function;
    protected float xScale;
    protected float yScale;
    protected float xTrans;
    protected float yTrans;
    private ROI roi;
    private Range nodata;
    private boolean hasROI;
    private float destNoData;
    private PlanarImage roiImage;
    private Rectangle roiBounds;

    private static SampleModel sampleModelHelper(int numBands, ImageLayout layout) {
        SampleModel sampleModel;
        if (layout != null && layout.isValid(256)) {
            sampleModel = layout.getSampleModel(null);
            if (sampleModel.getNumBands() != numBands) {
                throw new RuntimeException(JaiI18N.getString("ImageFunctionRIF0"));
            }
        } else {
            sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)1, (int)1, (int)numBands);
        }
        return sampleModel;
    }

    public ImageFunctionOpImage(ImageFunction function, int minX, int minY, int width, int height, float xScale, float yScale, float xTrans, float yTrans, ROI roi, Range nodata, float destNoData, Map config, ImageLayout layout) {
        super(layout, config, ImageFunctionOpImage.sampleModelHelper(function.getNumElements() * (function.isComplex() ? 2 : 1), layout), minX, minY, width, height);
        this.function = function instanceof ImageFunctionExt ? (ImageFunctionExt)function : new ImageFunctionExtWrapper(function);
        this.xScale = xScale;
        this.yScale = yScale;
        this.xTrans = xTrans;
        this.yTrans = yTrans;
        boolean bl = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roiBounds = roi.getBounds();
            this.roi = roi;
        }
        if (nodata != null) {
            this.nodata = RangeFactory.convertToFloatRange((Range)nodata);
        }
        this.destNoData = destNoData;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        int dataType = this.sampleModel.getTransferType();
        int numBands = this.sampleModel.getNumBands();
        boolean roiDisjointTile = false;
        ROI roiTile = null;
        if (this.hasROI) {
            Rectangle srcRectExpanded = destRect.getBounds();
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            }
        }
        if (roiDisjointTile) {
            double[] bkg = new double[this.function.isComplex() ? 2 : 1];
            bkg[0] = this.destNoData;
            if (this.function.isComplex()) {
                bkg[1] = this.destNoData;
            }
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])bkg);
            return;
        }
        int length = this.width * this.height;
        Object data = dataType == 5 ? (this.function.isComplex() ? (Object)new double[2][length] : new double[length]) : (Object)(this.function.isComplex() ? (Object)new float[2][length] : new float[length]);
        if (dataType == 5) {
            Object real = this.function.isComplex() ? ((double[][])data)[0] : data;
            double[] imag = this.function.isComplex() ? ((double[][])data)[1] : null;
            int element = 0;
            for (int band = 0; band < numBands; ++band) {
                this.function.getElements((double)(this.xScale * ((float)destRect.x - this.xTrans)), (double)(this.yScale * ((float)destRect.y - this.yTrans)), (double)this.xScale, (double)this.yScale, destRect.width, destRect.height, element++, (double[])real, imag, destRect, roiTile, this.nodata, this.destNoData);
                dest.setSamples(destRect.x, destRect.y, destRect.width, destRect.height, band, (double[])real);
                if (!this.function.isComplex()) continue;
                dest.setSamples(destRect.x, destRect.y, destRect.width, destRect.height, ++band, imag);
            }
        } else {
            float[] real = this.function.isComplex() ? ((float[][])data)[0] : (float[])data;
            float[] imag = this.function.isComplex() ? ((float[][])data)[1] : null;
            int element = 0;
            for (int band = 0; band < numBands; ++band) {
                this.function.getElements(this.xScale * ((float)destRect.x - this.xTrans), this.yScale * ((float)destRect.y - this.yTrans), this.xScale, this.yScale, destRect.width, destRect.height, element++, real, imag, destRect, roiTile, this.nodata, this.destNoData);
                dest.setSamples(destRect.x, destRect.y, destRect.width, destRect.height, band, real);
                if (!this.function.isComplex()) continue;
                dest.setSamples(destRect.x, destRect.y, destRect.width, destRect.height, ++band, imag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            ImageFunctionOpImage imageFunctionOpImage = this;
            synchronized (imageFunctionOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

