/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.util.List;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.rest.controller.GWCController;
import org.geowebcache.rest.converter.XStreamListAliasWrapper;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.storage.BlobStoreAggregator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest/blobstores"})
public class BlobStoreController
extends GWCController {
    @Autowired
    private BlobStoreAggregator blobStores;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/xml", "application/json", "text/xml"})
    public XStreamListAliasWrapper blobStoresGet() {
        return new XStreamListAliasWrapper(this.blobStores.getBlobStoreNames(), "blobStore", List.class, this.getClass());
    }

    @RequestMapping(path={"/{blobStoreName}"}, method={RequestMethod.GET}, produces={"application/xml", "application/json", "text/xml"})
    public BlobStoreInfo blobStoreGet(@PathVariable String blobStoreName) {
        try {
            return this.blobStores.getBlobStore(blobStoreName);
        }
        catch (GeoWebCacheException e) {
            throw new RestException("Failed to get BlobStoreInfo. A BlobStoreInfo with name \"%s\" does not exist.".formatted(blobStoreName), HttpStatus.NOT_FOUND, e);
        }
    }

    @RequestMapping(path={"/{blobStoreName}"}, method={RequestMethod.PUT}, consumes={"application/xml", "application/json", "text/xml"})
    public ResponseEntity<?> blobStorePut(@PathVariable String blobStoreName, @RequestBody BlobStoreInfo blobStore) {
        if (!this.blobStores.blobStoreExists(blobStoreName)) {
            this.blobStores.addBlobStore(blobStore);
            return new ResponseEntity((Object)"", HttpStatus.CREATED);
        }
        this.blobStores.modifyBlobStore(blobStore);
        return null;
    }

    @RequestMapping(path={"/{blobStoreName}"}, method={RequestMethod.DELETE})
    public void blobStoreDelete(@PathVariable String blobStoreName) {
        if (!this.blobStores.blobStoreExists(blobStoreName)) {
            throw new RestException("Failed to remove BlobStoreInfo. A BlobStoreInfo with name \"%s\" does not exist.".formatted(blobStoreName), HttpStatus.NOT_FOUND);
        }
        this.blobStores.removeBlobStore(blobStoreName);
    }
}

