/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.exception.RestException;
import org.springframework.http.HttpStatus;

public class GWCController {
    protected static TileLayer findTileLayer(String layerName, TileLayerDispatcher layerDispatcher) throws RestException {
        TileLayer layer;
        if (layerName == null || layerName.length() == 0) {
            throw new RestException("Layer not specified", HttpStatus.BAD_REQUEST);
        }
        if (!layerDispatcher.layerExists(layerName = layerName.replace("+", " "))) {
            throw new RestException("Unknown layer: " + layerName, HttpStatus.NOT_FOUND);
        }
        try {
            layer = layerDispatcher.getTileLayer(layerName);
        }
        catch (GeoWebCacheException gwce) {
            throw new RestException("Encountered error: " + gwce.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return layer;
    }
}

