/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.util.Set;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.rest.controller.GWCController;
import org.geowebcache.rest.converter.XStreamListAliasWrapper;
import org.geowebcache.rest.exception.RestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest/gridsets"})
public class GridSetController
extends GWCController {
    @Autowired
    GridSetBroker broker;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/xml", "application/json", "text/xml"})
    public XStreamListAliasWrapper gridSetsGet() {
        return new XStreamListAliasWrapper(this.broker.getGridSetNames(), "gridSet", Set.class, this.getClass());
    }

    @RequestMapping(path={"/{gridSetName}"}, method={RequestMethod.GET}, produces={"application/xml", "application/json", "text/xml"})
    public GridSet gridSetGet(@PathVariable String gridSetName) {
        if (this.broker.get(gridSetName) != null) {
            return this.broker.get(gridSetName);
        }
        throw new RestException("Failed to get GridSet. A GridSet with name \"%s\" does not exist.".formatted(gridSetName), HttpStatus.NOT_FOUND);
    }

    @RequestMapping(path={"/{gridSetName}"}, method={RequestMethod.PUT}, consumes={"application/xml", "application/json", "text/xml"})
    public ResponseEntity<?> gridSetPut(@PathVariable String gridSetName, @RequestBody GridSet gridSet) {
        if (this.broker.get(gridSetName) == null) {
            this.broker.addGridSet(gridSet);
            return new ResponseEntity((Object)"", HttpStatus.CREATED);
        }
        this.broker.put(gridSet);
        return null;
    }

    @RequestMapping(path={"/{gridSetName}"}, method={RequestMethod.DELETE})
    public void gridSetDelete(@PathVariable String gridSetName) {
        if (this.broker.get(gridSetName) == null) {
            throw new RestException("Failed to remove GridSet. A GridSet with name \"%s\" does not exist.".formatted(gridSetName), HttpStatus.NOT_FOUND);
        }
        this.broker.removeGridSet(gridSetName);
    }
}

