/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import java.io.IOException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.WMSRasterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.rest.filter.XmlFilterUpdate;
import org.springframework.http.HttpStatus;

public class FileRasterFilterUpdate
extends XmlFilterUpdate {
    String gridSetId;
    int zoomStart;
    int zoomStop;

    @Override
    public void runUpdate(RequestFilter filter, TileLayer tl) throws IOException, RestException {
        if (!(filter instanceof WMSRasterFilter)) {
            throw new RestException("The filter " + filter.getName() + " is not a WMSRasterFilter.", HttpStatus.BAD_REQUEST);
        }
        WMSRasterFilter wmsFilter = (WMSRasterFilter)filter;
        if (tl.getGridSubset(this.gridSetId) == null) {
            throw new RestException("The filter " + wmsFilter.getName() + " is associated with a layer that does not support " + this.gridSetId, HttpStatus.BAD_REQUEST);
        }
        try {
            for (int z = this.zoomStart; z <= this.zoomStop; ++z) {
                wmsFilter.setMatrix(tl, this.gridSetId, z, true);
            }
        }
        catch (GeoWebCacheException e) {
            throw new RestException("Error updating " + wmsFilter.getName() + ": " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

