/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.geotools.util.logging.Logging;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.handlers.xsi.AttributeHandler;
import org.geotools.xml.handlers.xsi.ComplexTypeHandler;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Any;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentWriter {
    public static final Logger logger = Logging.getLogger(DocumentWriter.class);
    private static Level level = Level.WARNING;
    public static final String WRITE_SCHEMA = "DocumentWriter_WRITE_SCHEMA";
    public static final String BASE_ELEMENT = "DocumentWriter_BASE_ELEMENT";
    public static final String SCHEMA_ORDER = "DocumentWriter_SCHEMA_ORDER";
    public static final String ENCODING = "DocumentWriter_ENCODING";
    public static final String USE_NEAREST = "DocumentWriter_USE_NEAREST";
    public static final String SCHEMA_LOCATION_HINT = "DocumentWriter_SCHEMA_LOCATION_HINT";

    public static void setLevel(Level l) {
        level = l;
        logger.setLevel(l);
    }

    public static void writeDocument(Object value, Schema schema, File f, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        if (f == null || !f.canWrite()) {
            throw new IOException("Cannot write to " + String.valueOf(f));
        }
        if (hints != null && hints.containsKey(WRITE_SCHEMA)) {
            HashMap<String, Object> hints2 = new HashMap<String, Object>(hints);
            hints2.remove(WRITE_SCHEMA);
            File f2 = new File(f.getParentFile(), f.getName().substring(0, f.getName().indexOf(".")) + ".xsd");
            try (FileWriter wf = new FileWriter(f2, StandardCharsets.UTF_8);){
                DocumentWriter.writeSchema(schema, wf, hints2);
            }
        }
        try (FileWriter wf = new FileWriter(f, StandardCharsets.UTF_8);){
            DocumentWriter.writeDocument(value, schema, wf, hints);
        }
    }

    public static void writeDocument(Object value, Schema schema, Writer w, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        if (hints != null && hints.containsKey(WRITE_SCHEMA)) {
            Writer w2 = (Writer)hints.get(WRITE_SCHEMA);
            DocumentWriter.writeSchema(schema, w2, hints);
        }
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        wch.startDocument();
        DocumentWriter.writeFragment(value, wch);
        wch.endDocument();
        w.flush();
    }

    public static void writeFragment(Object value, Schema schema, File f, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        if (f == null || !f.canWrite()) {
            throw new IOException("Cannot write to " + String.valueOf(f));
        }
        try (FileWriter wf = new FileWriter(f, StandardCharsets.UTF_8);){
            DocumentWriter.writeFragment(value, schema, wf, hints);
        }
    }

    public static void writeFragment(Object value, Schema schema, Writer w, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        DocumentWriter.writeFragment(value, wch);
        w.flush();
    }

    private static void writeFragment(Object value, WriterContentHandler wch) throws OperationNotSupportedException, IOException {
        Element e = null;
        logger.setLevel(level);
        if (wch.hints != null && wch.hints.containsKey(BASE_ELEMENT) && (e = (Element)wch.hints.get(BASE_ELEMENT)) != null && e.getType() != null) {
            Element element = e = e.getType().canEncode(e, value, wch.hints) ? e : null;
        }
        if (e == null) {
            e = wch.findElement(value);
        }
        if (e == null) {
            throw new OperationNotSupportedException("Could not find an appropriate Element to use for encoding of a " + (value == null ? null : value.getClass().getName()));
        }
        Type type = e.getType();
        type.encode(e, value, wch, wch.hints);
    }

    public static void writeSchema(Schema schema, Writer w, Map<String, Object> hints) throws IOException {
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        Element[] elems = schema.getElements();
        if (elems == null) {
            throw new IOException("Cannot write for Schema " + String.valueOf(schema.getTargetNamespace()));
        }
        wch.startDocument();
        DocumentWriter.writeSchema(schema, wch, hints);
        wch.endDocument();
    }

    private static void writeSchema(Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        Schema[] imports;
        if (schema == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        ai.addAttribute("", "targetNamespace", "", "anyUri", schema.getTargetNamespace().toString());
        ai.addAttribute("", "xmlns", "", "anyUri", XSISimpleTypes.NAMESPACE.toString());
        ai.addAttribute("", "xmlns:" + schema.getPrefix(), "", "anyUri", schema.getTargetNamespace().toString());
        for (Schema value : imports = schema.getImports()) {
            ai.addAttribute("", "xmlns:" + value.getPrefix(), "", "anyUri", value.getTargetNamespace().toString());
        }
        if (schema.getId() != null && !schema.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", schema.getId());
        }
        if (schema.getVersion() != null && !schema.getVersion().isEmpty()) {
            ai.addAttribute("", "version", "", "String", schema.getVersion());
        }
        if (schema.isAttributeFormDefault()) {
            ai.addAttribute("", "attributeFormDefault", "", "NMTOKEN", "qualified");
        }
        if (schema.isElementFormDefault()) {
            ai.addAttribute("", "elementFormDefault", "", "NMTOKEN", "qualified");
        }
        if (schema.getBlockDefault() != 0) {
            ai.addAttribute("", "blockDefault", "", "NMTOKENS", ComplexTypeHandler.writeBlock(schema.getBlockDefault()));
        }
        if (schema.getFinalDefault() != 0) {
            ai.addAttribute("", "finalDefault", "", "NMTOKENS", ComplexTypeHandler.writeFinal(schema.getFinalDefault()));
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "schema", ai);
        for (Schema anImport : imports) {
            DocumentWriter.writeImport(anImport, ph);
        }
        Element[] elems = schema.getElements();
        if (elems != null) {
            for (Element elem : elems) {
                DocumentWriter.writeElement(elem, schema, ph, hints);
            }
        }
        ComplexType[] cts = schema.getComplexTypes();
        if (elems != null) {
            for (ComplexType ct : cts) {
                DocumentWriter.writeComplexType(ct, schema, ph, hints);
            }
        }
        SimpleType[] sts = schema.getSimpleTypes();
        if (elems != null) {
            for (SimpleType st : sts) {
                DocumentWriter.writeSimpleType(st, schema, ph, hints);
            }
        }
        Group[] groups = schema.getGroups();
        if (elems != null) {
            for (Group group : groups) {
                DocumentWriter.writeGroup(group, schema, ph, hints);
            }
        }
        Attribute[] attrs = schema.getAttributes();
        if (elems != null) {
            for (Attribute attr : attrs) {
                DocumentWriter.writeAttribute(attr, schema, ph, hints);
            }
        }
        AttributeGroup[] attrgrps = schema.getAttributeGroups();
        if (elems != null) {
            for (AttributeGroup attrgrp : attrgrps) {
                DocumentWriter.writeAttributeGroup(attrgrp, schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "schema");
    }

    private static void writeImport(Schema schema, PrintHandler ph) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (schema.getId() != null && !schema.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", schema.getId());
        }
        ai.addAttribute("", "namespace", "", "anyUri", schema.getTargetNamespace().toString());
        if (schema.getURI() != null) {
            ai.addAttribute("", "schemaLocation", "", "anyUri", schema.getURI().toString());
        }
        ph.element(XSISimpleTypes.NAMESPACE, "import", ai);
    }

    private static void writeElement(Element element, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        Object s;
        AttributesImpl ai = new AttributesImpl();
        if (element.getId() != null && !element.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", element.getId());
        }
        if (element.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(element.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + element.getMaxOccurs()));
        }
        if (element.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + element.getMinOccurs());
        }
        boolean nested = false;
        if (element.getNamespace().equals(schema.getTargetNamespace())) {
            Element[] elems = schema.getElements();
            boolean found = false;
            for (int i = 0; i < elems.length && !found; ++i) {
                if (!element.getName().equals(elems[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", element.getName());
            }
            if (!found) {
                int i;
                if (!element.getType().getNamespace().equals(schema.getTargetNamespace())) {
                    found = true;
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s2 = SchemaFactory.getInstance(element.getNamespace());
                    if (element.getName() != null && !element.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", s2.getPrefix() + ":" + element.getType().getName());
                }
                Type[] types = schema.getComplexTypes();
                for (i = 0; i < types.length && !found; ++i) {
                    if (!element.getType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (element.getName() != null && !element.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", element.getType().getName());
                }
                types = schema.getSimpleTypes();
                for (i = 0; i < types.length && !found; ++i) {
                    if (!element.getType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (element.getName() != null && !element.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", element.getType().getName());
                }
                if (!found) {
                    nested = true;
                    if (element.getName() != null && !element.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                }
            }
        } else {
            s = SchemaFactory.getInstance(element.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + element.getName());
        }
        if (element.isNillable()) {
            ai.addAttribute("", "nillable", "", "boolean", "true");
        }
        if (element.getDefault() != null && !element.getDefault().isEmpty()) {
            ai.addAttribute("", "default", "", "String", element.getDefault());
        } else if (element.getFixed() != null && !element.getFixed().isEmpty()) {
            ai.addAttribute("", "fixed", "", "String", element.getFixed());
        }
        if (element.getSubstitutionGroup() != null) {
            s = "";
            if (!element.getSubstitutionGroup().getNamespace().equals(schema.getTargetNamespace())) {
                Schema sss = SchemaFactory.getInstance(element.getSubstitutionGroup().getNamespace());
                s = sss.getPrefix() + ":";
            }
            s = (String)s + element.getSubstitutionGroup().getName();
            ai.addAttribute("", "substitutionGroup", "", "QName", (String)s);
        }
        if (element.isForm()) {
            ai.addAttribute("", "form", "", "NMTOKEN", "qualified");
        }
        if (element.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(element.getFinal()));
        }
        if (element.getBlock() != 0) {
            ai.addAttribute("", "block", "", "NMTOKENS", ComplexTypeHandler.writeBlock(element.getBlock()));
        }
        if (element.isAbstract()) {
            ai.addAttribute("", "abstract", "", "boolean", "true");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "element", ai);
        if (nested) {
            if (element.getType() instanceof ComplexType) {
                DocumentWriter.writeComplexType((ComplexType)element.getType(), schema, ph, hints);
            } else {
                DocumentWriter.writeSimpleType((SimpleType)element.getType(), schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "element");
    }

    private static void writeAttribute(Attribute attribute, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (attribute.getId() != null && !attribute.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", attribute.getId());
        }
        boolean nested = false;
        if (attribute.getNamespace().equals(schema.getTargetNamespace())) {
            Attribute[] elems = schema.getAttributes();
            boolean found = false;
            for (int i = 0; i < elems.length && !found; ++i) {
                if (!attribute.getName().equals(elems[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", attribute.getName());
            }
            if (!found) {
                if (!attribute.getSimpleType().getNamespace().equals(schema.getTargetNamespace())) {
                    found = true;
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s = SchemaFactory.getInstance(attribute.getNamespace());
                    if (attribute.getName() != null && !attribute.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", s.getPrefix() + ":" + attribute.getSimpleType().getName());
                }
                SimpleType[] types = schema.getSimpleTypes();
                for (int i = 0; i < types.length && !found; ++i) {
                    if (!attribute.getSimpleType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (attribute.getName() != null && !attribute.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", attribute.getSimpleType().getName());
                }
                if (!found) {
                    nested = true;
                    if (attribute.getName() != null && !attribute.getName().isEmpty()) {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                }
            }
        } else {
            Schema s = SchemaFactory.getInstance(attribute.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + attribute.getName());
        }
        if (attribute.getUse() != 0) {
            ai.addAttribute("", "use", "", "NMTOKEN", AttributeHandler.writeUse(attribute.getUse()));
        }
        if (attribute.getDefault() != null && !attribute.getDefault().isEmpty()) {
            ai.addAttribute("", "default", "", "String", attribute.getDefault());
        } else if (attribute.getFixed() != null && !attribute.getFixed().isEmpty()) {
            ai.addAttribute("", "fixed", "", "String", attribute.getFixed());
        }
        if (attribute.isForm()) {
            ai.addAttribute("", "form", "", "NMTOKEN", "qualified");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "attribute", ai);
        if (nested) {
            DocumentWriter.writeSimpleType(attribute.getSimpleType(), schema, ph, hints);
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "attribute");
    }

    private static void writeGroup(Group group, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (group.getId() != null && !group.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", group.getId());
        }
        boolean nested = false;
        if (group.getNamespace().equals(schema.getTargetNamespace())) {
            Group[] groups = schema.getGroups();
            boolean found = false;
            for (int i = 0; i < groups.length && !found; ++i) {
                if (!group.getName().equals(groups[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", group.getName());
            }
            if (!found) {
                ai.addAttribute("", "name", "", "QName", group.getName());
                nested = true;
            }
        } else {
            XSISAXHandler.setLogLevel(logger.getLevel());
            Schema s = SchemaFactory.getInstance(group.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + group.getName());
        }
        if (group.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(group.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + group.getMaxOccurs()));
        }
        if (group.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + group.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "group", ai);
        if (nested) {
            if (group.getChild().getGrouping() == 16) {
                DocumentWriter.writeChoice((Choice)group.getChild(), schema, ph, hints);
            } else {
                DocumentWriter.writeSequence((Sequence)group.getChild(), schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "group");
    }

    private static void writeAttributeGroup(AttributeGroup attributeGroup, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (attributeGroup.getId() != null && !attributeGroup.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", attributeGroup.getId());
        }
        boolean nested = false;
        if (attributeGroup.getNamespace().equals(schema.getTargetNamespace())) {
            Group[] groups = schema.getGroups();
            boolean found = false;
            for (int i = 0; i < groups.length && !found; ++i) {
                if (!attributeGroup.getName().equals(groups[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", attributeGroup.getName());
            }
            if (!found) {
                ai.addAttribute("", "name", "", "QName", attributeGroup.getName());
                nested = true;
            }
        } else {
            XSISAXHandler.setLogLevel(logger.getLevel());
            Schema s = SchemaFactory.getInstance(attributeGroup.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + attributeGroup.getName());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "group", ai);
        if (nested) {
            if (attributeGroup.getAnyAttributeNameSpace() != null) {
                ai = new AttributesImpl();
                ai.addAttribute("", "namespace", "", "special", attributeGroup.getAnyAttributeNameSpace());
                ph.element(XSISimpleTypes.NAMESPACE, "anyAttribute", ai);
            }
            if (attributeGroup.getAttributes() != null) {
                Attribute[] attrs;
                for (Attribute attr : attrs = attributeGroup.getAttributes()) {
                    DocumentWriter.writeAttribute(attr, schema, ph, hints);
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "group");
    }

    private static void writeSimpleType(SimpleType simpleType, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (simpleType.getId() != null && !simpleType.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", simpleType.getId());
        }
        if (simpleType.getName() != null && !simpleType.getName().isEmpty()) {
            ai.addAttribute("", "name", "", "NCName", simpleType.getName());
        }
        if (simpleType.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(simpleType.getFinal()));
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "simpleType", ai);
        switch (simpleType.getChildType()) {
            case 4: {
                Facet[] facets;
                SimpleType st = simpleType.getParents()[0];
                ai = null;
                if (schema.getTargetNamespace().equals(st.getNamespace())) {
                    SimpleType[] sts;
                    if (st.getName() != null && !st.getName().isEmpty() && (sts = schema.getSimpleTypes()) != null) {
                        for (SimpleType type : sts) {
                            if (!st.getName().equals(type.getName())) continue;
                            ai = new AttributesImpl();
                            ai.addAttribute("", "base", "", "QName", st.getName());
                        }
                    }
                } else {
                    ai = new AttributesImpl();
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s = SchemaFactory.getInstance(st.getNamespace());
                    ai.addAttribute("", "base", "", "QName", s.getPrefix() + ":" + st.getName());
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "restriction", ai);
                if (ai == null) {
                    DocumentWriter.writeSimpleType(st, schema, ph, hints);
                }
                if ((facets = simpleType.getFacets()) != null) {
                    for (Facet facet : facets) {
                        DocumentWriter.writeFacet(facet, ph);
                    }
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "restriction");
                break;
            }
            case 2: {
                SimpleType st = simpleType.getParents()[0];
                ai = null;
                if (schema.getTargetNamespace().equals(st.getNamespace())) {
                    SimpleType[] sts;
                    if (st.getName() != null && !st.getName().isEmpty() && (sts = schema.getSimpleTypes()) != null) {
                        for (SimpleType type : sts) {
                            if (!st.getName().equals(type.getName())) continue;
                            ai = new AttributesImpl();
                            ai.addAttribute("", "itemType", "", "QName", st.getName());
                        }
                    }
                } else {
                    ai = new AttributesImpl();
                    Schema s = SchemaFactory.getInstance(st.getNamespace());
                    ai.addAttribute("", "itemType", "", "QName", s.getPrefix() + ":" + st.getName());
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "list", ai);
                if (ai == null) {
                    DocumentWriter.writeSimpleType(st, schema, ph, hints);
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "list");
                break;
            }
            case 1: {
                SimpleType[] sts = simpleType.getParents();
                Object memberTypes = null;
                LinkedList<SimpleType> childTs = new LinkedList<SimpleType>();
                if (sts != null) {
                    SimpleType[] facet = sts;
                    int n = facet.length;
                    for (int i = 0; i < n; ++i) {
                        SimpleType value;
                        SimpleType st = value = facet[i];
                        if (schema.getTargetNamespace().equals(st.getNamespace())) {
                            SimpleType[] sts2;
                            boolean found = false;
                            if (st.getName() != null && !st.getName().isEmpty() && (sts2 = schema.getSimpleTypes()) != null) {
                                for (SimpleType type : sts2) {
                                    if (!st.getName().equals(type.getName())) continue;
                                    found = true;
                                    memberTypes = memberTypes == null ? st.getName() : (String)memberTypes + " " + st.getName();
                                }
                            }
                            if (found) continue;
                            childTs.add(st);
                            continue;
                        }
                        ai = new AttributesImpl();
                        Schema s = SchemaFactory.getInstance(st.getNamespace());
                        memberTypes = memberTypes == null ? s.getPrefix() + ":" + st.getName() : (String)memberTypes + " " + s.getPrefix() + ":" + st.getName();
                    }
                }
                if (memberTypes != null) {
                    ai = new AttributesImpl();
                    ai.addAttribute("", "memberTypes", "", "QName", (String)memberTypes);
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "union", ai);
                if (!childTs.isEmpty()) {
                    Iterator i = childTs.iterator();
                    while (i.hasNext()) {
                        DocumentWriter.writeSimpleType((SimpleType)i.next(), schema, ph, hints);
                    }
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "union");
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "simpleType");
    }

    private static void writeChoice(Choice choice, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (choice.getId() != null && !choice.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", choice.getId());
        }
        if (choice.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(choice.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + choice.getMaxOccurs()));
        }
        if (choice.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + choice.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "choice", ai);
        ElementGrouping[] egs = choice.getChildren();
        if (egs != null) {
            block8: for (ElementGrouping eg : egs) {
                if (eg == null) continue;
                switch (eg.getGrouping()) {
                    case 32: {
                        DocumentWriter.writeAll((All)eg, schema, ph, hints);
                        continue block8;
                    }
                    case 4: {
                        DocumentWriter.writeAny((Any)eg, ph);
                        continue block8;
                    }
                    case 16: {
                        DocumentWriter.writeChoice((Choice)eg, schema, ph, hints);
                        continue block8;
                    }
                    case 1: {
                        DocumentWriter.writeElement((Element)eg, schema, ph, hints);
                        continue block8;
                    }
                    case 2: {
                        DocumentWriter.writeGroup((Group)eg, schema, ph, hints);
                        continue block8;
                    }
                    case 8: {
                        DocumentWriter.writeSequence((Sequence)eg, schema, ph, hints);
                    }
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "choice");
    }

    private static void writeSequence(Sequence sequence, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (sequence.getId() != null && !sequence.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", sequence.getId());
        }
        if (sequence.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(sequence.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + sequence.getMaxOccurs()));
        }
        if (sequence.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + sequence.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "sequence", ai);
        ElementGrouping[] egs = sequence.getChildren();
        if (egs != null) {
            block7: for (ElementGrouping eg : egs) {
                if (eg == null) continue;
                switch (eg.getGrouping()) {
                    case 4: {
                        DocumentWriter.writeAny((Any)eg, ph);
                        continue block7;
                    }
                    case 16: {
                        DocumentWriter.writeChoice((Choice)eg, schema, ph, hints);
                        continue block7;
                    }
                    case 1: {
                        DocumentWriter.writeElement((Element)eg, schema, ph, hints);
                        continue block7;
                    }
                    case 2: {
                        DocumentWriter.writeGroup((Group)eg, schema, ph, hints);
                        continue block7;
                    }
                    case 8: {
                        DocumentWriter.writeSequence((Sequence)eg, schema, ph, hints);
                    }
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "sequence");
    }

    private static void writeAll(All all, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (all.getId() != null && !all.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", all.getId());
        }
        if (all.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(all.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + all.getMaxOccurs()));
        }
        if (all.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + all.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "all", ai);
        Element[] egs = all.getElements();
        if (egs != null) {
            for (Element eg : egs) {
                if (eg == null) continue;
                DocumentWriter.writeElement(eg, schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "all");
    }

    private static void writeAny(Any any, PrintHandler ph) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (any.getId() != null && !any.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", any.getId());
        }
        if (any.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", (String)(any.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + any.getMaxOccurs()));
        }
        if (any.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + any.getMinOccurs());
        }
        if (any.getNamespace() != null) {
            ai.addAttribute("", "namespace", "", "special", String.valueOf(any.getNamespace()));
        }
        ph.element(XSISimpleTypes.NAMESPACE, "any", ai);
    }

    private static void writeComplexType(ComplexType complexType, Schema schema, PrintHandler ph, Map<String, Object> hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (complexType.getId() != null && !complexType.getId().isEmpty()) {
            ai.addAttribute("", "id", "", "ID", complexType.getId());
        }
        if (complexType.getName() != null && !complexType.getName().isEmpty()) {
            ai.addAttribute("", "name", "", "NCName", complexType.getName());
        }
        if (complexType.isAbstract()) {
            ai.addAttribute("", "abstract", "", "boolean", "true");
        }
        if (complexType.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(complexType.getFinal()));
        }
        if (complexType.getBlock() != 0) {
            ai.addAttribute("", "block", "", "NMTOKENS", ComplexTypeHandler.writeBlock(complexType.getBlock()));
        }
        if (complexType.isMixed()) {
            ai.addAttribute("", "mixed", "", "boolean", "true");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "complexType", ai);
        ElementGrouping egs = complexType.getChild();
        complexType.getChild();
        if (egs != null) {
            switch (egs.getGrouping()) {
                case 32: {
                    DocumentWriter.writeAll((All)egs, schema, ph, hints);
                    break;
                }
                case 16: {
                    DocumentWriter.writeChoice((Choice)egs, schema, ph, hints);
                    break;
                }
                case 2: {
                    DocumentWriter.writeGroup((Group)egs, schema, ph, hints);
                    break;
                }
                case 8: {
                    DocumentWriter.writeSequence((Sequence)egs, schema, ph, hints);
                }
            }
        }
        if (complexType.getAnyAttributeNameSpace() != null) {
            ai = new AttributesImpl();
            ai.addAttribute("", "namespace", "", "special", complexType.getAnyAttributeNameSpace());
            ph.element(XSISimpleTypes.NAMESPACE, "anyAttribute", ai);
        }
        if (complexType.getAttributes() != null) {
            Attribute[] attrs;
            for (Attribute attr : attrs = complexType.getAttributes()) {
                DocumentWriter.writeAttribute(attr, schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "complexType");
    }

    private static void writeFacet(Facet facet, PrintHandler ph) throws IOException {
        if (facet == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        ai.addAttribute("", "value", "", "ID", facet.getValue());
        switch (facet.getFacetType()) {
            case 1: {
                ph.element(XSISimpleTypes.NAMESPACE, "enumeration", ai);
                break;
            }
            case 2: {
                ph.element(XSISimpleTypes.NAMESPACE, "fractionDigits", ai);
                break;
            }
            case 3: {
                ph.element(XSISimpleTypes.NAMESPACE, "length", ai);
                break;
            }
            case 4: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxExclusive", ai);
                break;
            }
            case 5: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxInclusive", ai);
                break;
            }
            case 6: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxLength", ai);
                break;
            }
            case 7: {
                ph.element(XSISimpleTypes.NAMESPACE, "minExclusive", ai);
                break;
            }
            case 8: {
                ph.element(XSISimpleTypes.NAMESPACE, "minInclusive", ai);
                break;
            }
            case 9: {
                ph.element(XSISimpleTypes.NAMESPACE, "minLength", ai);
                break;
            }
            case 10: {
                ph.element(XSISimpleTypes.NAMESPACE, "pattern", ai);
                break;
            }
            case 11: {
                ph.element(XSISimpleTypes.NAMESPACE, "totalDigits", ai);
                break;
            }
            case 12: {
                ph.element(XSISimpleTypes.NAMESPACE, "whiteSpace", ai);
            }
        }
    }

    private static class WriterContentHandler
    implements PrintHandler {
        private boolean firstElement = true;
        private Writer writer;
        private Map<URI, String> prefixMappings;
        private Schema schema;
        protected Map<String, Object> hints;
        private Schema[] searchOrder = null;
        private String encoding = "UTF-8";

        WriterContentHandler(Schema schema, Writer writer, Map<String, Object> hints) {
            Object encodingValue;
            this.writer = writer;
            this.schema = schema;
            this.hints = hints;
            if (this.hints != null && (encodingValue = this.getHint(DocumentWriter.ENCODING)) != null) {
                this.encoding = encodingValue.toString();
            }
            this.prefixMappings = new HashMap<URI, String>();
            this.prefixMappings.put(schema.getTargetNamespace(), "");
            Schema[] imports = schema.getImports();
            if (imports != null) {
                for (Schema anImport : imports) {
                    this.prefixMappings.put(anImport.getTargetNamespace(), anImport.getPrefix());
                }
            }
        }

        private void printXMLNSDecs(Map arg0) throws IOException {
            Schema[] imports = this.getSchemaOrdering();
            Object s = "";
            Map schemaLocs = arg0 == null ? null : arg0.get(DocumentWriter.SCHEMA_LOCATION_HINT);
            schemaLocs = schemaLocs == null ? new HashMap() : schemaLocs;
            for (Schema anImport : imports) {
                if (anImport == null) continue;
                if (anImport == this.schema) {
                    this.writer.write(" xmlns=\"" + String.valueOf(this.schema.getTargetNamespace()) + "\"");
                    if (this.schema.getURI() != null && !this.schema.getTargetNamespace().equals(this.schema.getURI())) {
                        String endResult = this.schema.getURI().toString();
                        endResult = endResult.replaceAll("&", "&amp;");
                        s = String.valueOf(this.schema.getTargetNamespace()) + " " + endResult;
                    }
                } else {
                    this.writer.write(" xmlns:" + anImport.getPrefix() + "=\"" + String.valueOf(anImport.getTargetNamespace()) + "\"");
                }
                URI location = anImport.getURI();
                boolean forced = false;
                if (schemaLocs.containsKey(anImport.getTargetNamespace())) {
                    location = (URI)schemaLocs.get(anImport.getTargetNamespace());
                    forced = true;
                }
                if (location == null || !location.isAbsolute() || !anImport.includesURI(location) && !forced || location == null || location.equals(anImport.getTargetNamespace())) continue;
                String endResult = location.toString();
                endResult = endResult.replaceAll("&", "&amp;");
                s = (String)s + " " + String.valueOf(anImport.getTargetNamespace()) + " " + endResult;
            }
            if (!"".equals(s = ((String)s).trim())) {
                this.writer.write(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                this.writer.write(" xsi:schemaLocation=\"" + (String)s + "\"");
            }
        }

        @Override
        public void startElement(URI namespaceURI, String localName, Attributes attributes) throws IOException {
            Object prefix = this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!((String)prefix).equals("")) {
                    prefix = (String)prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (!((String)prefix).isEmpty()) {
                    prefix = (String)prefix + ":";
                }
            }
            this.writer.write("<");
            this.writer.write((String)prefix + localName);
            if (this.firstElement) {
                this.printXMLNSDecs(this.hints);
                this.firstElement = false;
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    this.writer.write(" ");
                    this.writer.write(name);
                    this.writer.write("=\"");
                    this.writer.write(value);
                    this.writer.write("\"");
                }
            }
            this.writer.write(">");
        }

        @Override
        public void element(URI namespaceURI, String localName, Attributes attributes) throws IOException {
            Object prefix = this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!((String)prefix).equals("")) {
                    prefix = (String)prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (!((String)prefix).isEmpty()) {
                    prefix = (String)prefix + ":";
                }
            }
            this.writer.write("<");
            this.writer.write((String)prefix + localName);
            if (this.firstElement) {
                this.printXMLNSDecs(this.hints);
                this.firstElement = false;
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    this.writer.write(" ");
                    this.writer.write(name);
                    this.writer.write("=\"");
                    this.writer.write(value);
                    this.writer.write("\"");
                }
            }
            this.writer.write("/>");
            this.writer.write("\n");
        }

        @Override
        public void endElement(URI namespaceURI, String localName) throws IOException {
            Object prefix = this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!((String)prefix).equals("")) {
                    prefix = (String)prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (!((String)prefix).isEmpty()) {
                    prefix = (String)prefix + ":";
                }
            }
            this.writer.write("</");
            this.writer.write((String)prefix + localName);
            this.writer.write(">");
            this.writer.write("\n");
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws IOException {
            this.writer.write(arg0, arg1, arg2);
        }

        @Override
        public void characters(String s) throws IOException {
            this.writer.write(s);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws IOException {
            this.writer.write(arg0, arg1, arg2);
        }

        @Override
        public void startDocument() throws IOException {
            this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.writer.write("\n");
        }

        @Override
        public void endDocument() throws IOException {
            this.writer.write("\n");
            this.writer.flush();
        }

        @Override
        public Schema getDocumentSchema() {
            return this.schema;
        }

        @Override
        public Object getHint(Object key) {
            return this.hints.get(key);
        }

        @Override
        public Element findElement(Object value) {
            Schema[] searchOrder1;
            try {
                searchOrder1 = this.getSchemaOrdering();
            }
            catch (IOException e) {
                logger.warning(e.toString());
                return null;
            }
            for (Schema item : searchOrder1) {
                Element[] elems = item.getElements();
                if (elems == null) continue;
                for (Element elem : elems) {
                    if (elem.getType() == null || !elem.getType().canEncode(elem, value, this.hints)) continue;
                    return elem;
                }
            }
            return null;
        }

        @Override
        public Element findElement(String name) {
            Schema[] searchOrder1;
            try {
                searchOrder1 = this.getSchemaOrdering();
            }
            catch (IOException e) {
                logger.warning(e.toString());
                return null;
            }
            for (Schema value : searchOrder1) {
                Element[] elems = value.getElements();
                if (elems == null) continue;
                for (Element elem : elems) {
                    if (elem.getName() == null || !elem.getName().equals(name)) continue;
                    return elem;
                }
            }
            return null;
        }

        private Schema[] getSchemaOrdering() throws IOException {
            if (this.searchOrder != null) {
                return this.searchOrder;
            }
            if (!(this.hints != null && this.hints.get(DocumentWriter.SCHEMA_ORDER) != null || this.schema.getImports() != null && this.schema.getImports().length != 0)) {
                this.searchOrder = new Schema[]{this.schema};
            } else {
                LinkedList<Schema> so = new LinkedList<Schema>();
                if (this.hints != null && this.hints.containsKey(DocumentWriter.SCHEMA_ORDER)) {
                    Object order = this.hints.get(DocumentWriter.SCHEMA_ORDER);
                    LinkedList<URI> targNS = new LinkedList<URI>();
                    targNS.add(this.schema.getTargetNamespace());
                    if (this.schema.getImports() != null) {
                        for (int i = 0; i < this.schema.getImports().length; ++i) {
                            if (targNS.contains(this.schema.getImports()[i].getTargetNamespace())) continue;
                            targNS.add(this.schema.getImports()[i].getTargetNamespace());
                        }
                    }
                    if (order instanceof Schema[]) {
                        Schema[] sOrder;
                        for (Schema value : sOrder = (Schema[])order) {
                            int nsIndex = targNS.indexOf(value.getTargetNamespace());
                            if (nsIndex < 0) continue;
                            so.add(value);
                            targNS.remove(nsIndex);
                        }
                    } else {
                        String[] stringOrder;
                        for (String s : stringOrder = (String[])order) {
                            int nsIndex = targNS.indexOf(s);
                            try {
                                URI uri;
                                if (nsIndex >= 0) {
                                    uri = new URI(s);
                                    XSISAXHandler.setLogLevel(logger.getLevel());
                                    so.add(SchemaFactory.getInstance(uri));
                                    targNS.remove(nsIndex);
                                    continue;
                                }
                                uri = new URI(s);
                                so.add(SchemaFactory.getInstance(uri));
                            }
                            catch (URISyntaxException e) {
                                logger.warning(e.toString());
                                IOException t = new IOException(e.toString());
                                t.initCause(e);
                                throw t;
                            }
                        }
                    }
                    if (!targNS.contains(this.schema.getTargetNamespace())) {
                        so.add(this.schema);
                    }
                    for (int i = 0; i < this.schema.getImports().length; ++i) {
                        int nsIndex = targNS.indexOf(this.schema.getImports()[i].getTargetNamespace());
                        if (nsIndex < 0) continue;
                        so.add(this.schema.getImports()[i]);
                        targNS.remove(nsIndex);
                    }
                } else if (this.hints != null && this.hints.containsKey(DocumentWriter.USE_NEAREST)) {
                    so.add(this.schema);
                    for (int i = 0; i < this.schema.getImports().length; ++i) {
                        so.add(this.schema.getImports()[i]);
                    }
                } else {
                    so.add(this.schema);
                    for (int i = 0; i < this.schema.getImports().length; ++i) {
                        so.add(this.schema.getImports()[i]);
                    }
                }
                this.searchOrder = so.toArray(new Schema[so.size()]);
            }
            return this.searchOrder;
        }
    }
}

