/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaResolver;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaFactory {
    private static final Logger LOGGER = Logger.getLogger(SchemaFactory.class.getName());
    protected static SchemaFactory is = new SchemaFactory();
    private Map<URI, Schema> schemas = this.loadSchemas();
    File cacheDir;
    private SchemaResolver resolver;
    private SAXParser parser;

    protected SchemaFactory() {
        this.initResolver();
    }

    private void initResolver() {
        try {
            if (System.getProperty("schema.factory.cache", null) == null) {
                File tempFolder = File.createTempFile("schema", "cache");
                tempFolder.delete();
                tempFolder.mkdirs();
                this.cacheDir = tempFolder;
            } else {
                this.cacheDir = new File(System.getProperty("schema.factory.cache"));
            }
            this.resolver = new SchemaResolver(new SchemaCache(this.cacheDir, true));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected static SchemaFactory getInstance() {
        return is;
    }

    private Map<URI, Schema> loadSchemas() {
        this.schemas = new HashMap<URI, Schema>();
        ClassLoader[] cls = this.findLoaders();
        String serviceId = "META-INF/services/" + Schema.class.getName();
        for (ClassLoader cl : cls) {
            try {
                Enumeration<URL> e = cl.getResources(serviceId);
                block10: while (e.hasMoreElements()) {
                    URL res = e.nextElement();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(res.openStream(), "UTF-8"));
                    block11: while (true) {
                        while (rd.ready()) {
                            String factoryClassName = rd.readLine().trim();
                            try {
                                Schema s = (Schema)cl.loadClass(factoryClassName).getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                                this.schemas.put(s.getTargetNamespace(), s);
                                continue block11;
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                                XSISAXHandler.logger.warning(e1.toString());
                            }
                        }
                        continue block10;
                        {
                            continue block11;
                            break;
                        }
                        break;
                    }
                    finally {
                        rd.close();
                    }
                }
            }
            catch (IOException e) {
                XSISAXHandler.logger.warning(e.toString());
            }
        }
        return this.schemas;
    }

    private ClassLoader[] findLoaders() {
        ClassLoader contextLoader = null;
        try {
            contextLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader systemLoader = ReferencingFactoryFinder.class.getClassLoader();
        ClassLoader[] classLoaders = contextLoader == null || contextLoader == systemLoader ? new ClassLoader[]{systemLoader} : new ClassLoader[]{contextLoader, systemLoader};
        return classLoaders;
    }

    public static Schema getInstance(URI targetNamespace, URI desiredSchema) throws SAXException {
        return SchemaFactory.getInstance(targetNamespace, desiredSchema, Level.WARNING);
    }

    public static Schema getInstance(URI targetNamespace, InputStream is1) throws SAXException {
        return SchemaFactory.getInstance(targetNamespace, is1, Level.WARNING);
    }

    public static synchronized Schema getInstance(String targetNamespace) {
        try {
            URI uri = new URI(targetNamespace);
            return SchemaFactory.getInstance(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static synchronized Schema getInstance(URI targetNamespace) {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace);
    }

    public static synchronized Schema[] getSchemas(String prefix) {
        if (prefix == null) {
            return null;
        }
        SchemaFactory sf = SchemaFactory.getInstance();
        Iterator<Schema> i = sf.schemas.values().iterator();
        LinkedList<Schema> l = new LinkedList<Schema>();
        while (i.hasNext()) {
            Schema s = i.next();
            if (!prefix.equals(s.getPrefix())) continue;
            l.add(s);
        }
        return l.toArray(new Schema[l.size()]);
    }

    private synchronized Schema getRealInstance(URI targetNamespace) {
        Schema r = this.schemas.get(targetNamespace);
        if (r != null) {
            return r;
        }
        return null;
    }

    public static synchronized Schema getInstance(URI targetNamespace, URI desiredSchema, Level level) throws SAXException {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace, desiredSchema, level);
    }

    private synchronized Schema getRealInstance(URI targetNamespace2, URI desiredSchema, Level level) throws SAXException {
        URI targetNamespace = targetNamespace2;
        if (targetNamespace == null || this.schemas.get(targetNamespace) == null) {
            this.setParser();
            XSISAXHandler contentHandler = this.getSAXHandler(desiredSchema);
            XSISAXHandler.setLogLevel(level);
            try {
                this.parser.parse(this.resolveSchema(desiredSchema), (DefaultHandler)contentHandler);
            }
            catch (IOException e) {
                try {
                    this.parser.parse(desiredSchema.toString(), (DefaultHandler)contentHandler);
                }
                catch (IOException e1) {
                    throw new SAXException(e1);
                }
            }
            Schema schema = contentHandler.getSchema();
            if (targetNamespace == null || "".equals(targetNamespace.toString())) {
                targetNamespace = schema.getTargetNamespace();
            }
            if (this.schemas.get(targetNamespace) != null) {
                schema = this.merge(schema, this.schemas.get(targetNamespace));
            }
            this.schemas.put(targetNamespace, schema);
            return schema;
        }
        if (!this.schemas.get(targetNamespace).includesURI(desiredSchema)) {
            Schema sh = this.schemas.get(targetNamespace);
            this.setParser();
            XSISAXHandler contentHandler = this.getSAXHandler(desiredSchema);
            XSISAXHandler.setLogLevel(level);
            try {
                this.parser.parse(this.resolveSchema(desiredSchema), (DefaultHandler)contentHandler);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            sh = this.merge(sh, contentHandler.getSchema());
            this.schemas.put(targetNamespace, sh);
        }
        return this.schemas.get(targetNamespace);
    }

    private String resolveSchema(URI schema) {
        return this.resolver.resolve(schema.toString());
    }

    protected XSISAXHandler getSAXHandler(URI uri) {
        return new XSISAXHandler(uri);
    }

    public static synchronized Schema getInstance(URI targetNamespace, InputStream is1, Level level) throws SAXException {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace, is1, level);
    }

    private synchronized Schema getRealInstance(URI targetNamespace2, InputStream is1, Level level) throws SAXException {
        URI targetNamespace = targetNamespace2;
        if (targetNamespace == null || this.schemas.get(targetNamespace) == null) {
            XSISAXHandler contentHandler = this.parseSchema(is1, level);
            if (targetNamespace == null || "".equals(targetNamespace.toString())) {
                targetNamespace = contentHandler.getSchema().getTargetNamespace();
            }
            Schema schema = contentHandler.getSchema();
            if (this.schemas.get(targetNamespace) != null) {
                schema = this.merge(schema, this.schemas.get(targetNamespace));
            }
            this.schemas.put(targetNamespace, schema);
        } else {
            Schema sh = this.schemas.get(targetNamespace);
            XSISAXHandler contentHandler = this.parseSchema(is1, level);
            sh = this.merge(sh, contentHandler.getSchema());
            this.schemas.put(targetNamespace, sh);
        }
        return this.schemas.get(targetNamespace);
    }

    private XSISAXHandler parseSchema(InputStream is1, Level level) throws SAXException {
        this.setParser();
        XSISAXHandler contentHandler = this.getSAXHandler(null);
        XSISAXHandler.setLogLevel(level);
        try {
            this.parser.parse(is1, (DefaultHandler)contentHandler);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return contentHandler;
    }

    private Schema merge(Schema s1, Schema s2) throws SAXException {
        return new MergedSchema(s1, s2);
    }

    public static void registerSchema(URI targetNamespace, Schema schema) {
        SchemaFactory.getInstance().registerRealSchema(targetNamespace, schema);
    }

    private void registerRealSchema(URI targetNamespace, Schema schema) {
        this.schemas.put(targetNamespace, schema);
    }

    private void setParser() throws SAXException {
        if (this.parser == null) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            try {
                this.parser = spf.newSAXParser();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class MergedSchema
    implements Schema {
        private AttributeGroup[] attributeGroups;
        private Attribute[] attributes;
        private int block;
        private int finaL;
        private ComplexType[] complexTypes;
        private Element[] elements;
        private Group[] groups;
        private String id;
        private String version;
        private String prefix;
        private URI targetNamespace;
        private Schema[] imports;
        private SimpleType[] simpleTypes;
        private boolean aForm;
        private boolean eForm;
        private URI uri;

        /*
         * WARNING - void declaration
         */
        public MergedSchema(Schema s1, Schema s2) throws SAXException {
            Schema[] i2;
            Group[] g2;
            Element[] e2;
            SimpleType[] ss2;
            void var9_20;
            ComplexType[] c2;
            void var9_17;
            Attribute[] a2;
            AttributeGroup[] ag2;
            this.id = s1.getId() == null || s1.getId().equals("") ? s2.getId() : s1.getId();
            this.version = s1.getVersion() == null || s1.getVersion().equals("") ? s2.getVersion() : s1.getVersion();
            if (s1.getTargetNamespace() == null || s1.getTargetNamespace().toString().isEmpty()) {
                this.targetNamespace = s2.getTargetNamespace();
            } else {
                if (s2.getTargetNamespace() != null && !s1.getTargetNamespace().equals(s2.getTargetNamespace())) {
                    throw new SAXException("cannot merge two target namespaces. " + String.valueOf(s1.getTargetNamespace()) + " " + String.valueOf(s2.getTargetNamespace()));
                }
                this.targetNamespace = s1.getTargetNamespace();
            }
            this.aForm = s1.isAttributeFormDefault() || s2.isAttributeFormDefault();
            this.eForm = s1.isElementFormDefault() || s2.isElementFormDefault();
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            AttributeGroup[] ag1 = s1.getAttributeGroups();
            if (ag1 == null) {
                ag1 = new AttributeGroup[]{};
            }
            if ((ag2 = s2.getAttributeGroups()) == null) {
                ag2 = new AttributeGroup[]{};
            }
            for (AttributeGroup attributeGroup : ag1) {
                m.put(attributeGroup.getName(), attributeGroup);
            }
            for (AttributeGroup attributeGroup : ag2) {
                if (m.containsKey(attributeGroup.getName())) continue;
                m.put(attributeGroup.getName(), attributeGroup);
            }
            this.attributeGroups = new AttributeGroup[m.size()];
            Object[] obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.attributeGroups[i] = (AttributeGroup)obj[i];
            }
            m = new HashMap();
            Attribute[] a1 = s1.getAttributes();
            if (a1 == null) {
                a1 = new Attribute[]{};
            }
            if ((a2 = s2.getAttributes()) == null) {
                a2 = new Attribute[]{};
            }
            for (Attribute attribute1 : a1) {
                m.put(attribute1.getName(), attribute1);
            }
            for (Attribute attribute : a2) {
                if (m.containsKey(attribute.getName())) continue;
                m.put(attribute.getName(), attribute);
            }
            this.attributes = new Attribute[m.size()];
            obj = m.values().toArray();
            boolean bl = false;
            while (var9_17 < obj.length) {
                this.attributes[var9_17] = (Attribute)obj[var9_17];
                ++var9_17;
            }
            this.block = s1.getBlockDefault() | s2.getBlockDefault();
            this.finaL = s1.getFinalDefault() | s2.getFinalDefault();
            m = new HashMap();
            ComplexType[] complexTypeArray = s1.getComplexTypes();
            if (complexTypeArray == null) {
                ComplexType[] complexTypeArray2 = new ComplexType[]{};
            }
            if ((c2 = s2.getComplexTypes()) == null) {
                c2 = new ComplexType[]{};
            }
            for (void complexType1 : var9_20) {
                m.put(complexType1.getName(), complexType1);
            }
            for (ComplexType complexType : c2) {
                if (m.containsKey(complexType.getName())) continue;
                m.put(complexType.getName(), complexType);
            }
            this.complexTypes = new ComplexType[m.size()];
            obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.complexTypes[i] = (ComplexType)obj[i];
            }
            m = new HashMap();
            SimpleType[] ss1 = s1.getSimpleTypes();
            if (ss1 == null) {
                ss1 = new SimpleType[]{};
            }
            if ((ss2 = s2.getSimpleTypes()) == null) {
                ss2 = new SimpleType[]{};
            }
            for (SimpleType type : ss1) {
                m.put(type.getName(), type);
            }
            for (SimpleType simpleType : ss2) {
                if (m.containsKey(simpleType.getName())) continue;
                m.put(simpleType.getName(), simpleType);
            }
            this.simpleTypes = new SimpleType[m.size()];
            obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.simpleTypes[i] = (SimpleType)obj[i];
            }
            m = new HashMap();
            Element[] e1 = s1.getElements();
            if (e1 == null) {
                e1 = new Element[]{};
            }
            if ((e2 = s2.getElements()) == null) {
                e2 = new Element[]{};
            }
            for (Element element1 : e1) {
                m.put(element1.getName(), element1);
            }
            for (Element element : e2) {
                if (m.containsKey(element.getName())) continue;
                m.put(element.getName(), element);
            }
            this.elements = new Element[m.size()];
            obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.elements[i] = (Element)obj[i];
            }
            m = new HashMap();
            Group[] g1 = s1.getGroups();
            if (g1 == null) {
                g1 = new Group[]{};
            }
            if ((g2 = s2.getGroups()) == null) {
                g2 = new Group[]{};
            }
            for (Group item : g1) {
                m.put(item.getName(), item);
            }
            for (Group group : g2) {
                if (m.containsKey(group.getName())) continue;
                m.put(group.getName(), group);
            }
            this.groups = new Group[m.size()];
            obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.groups[i] = (Group)obj[i];
            }
            m = new HashMap();
            Schema[] i1 = s1.getImports();
            if (i1 == null) {
                i1 = new Schema[]{};
            }
            if ((i2 = s2.getImports()) == null) {
                i2 = new Schema[]{};
            }
            for (Schema value : i1) {
                m.put(value.getTargetNamespace(), value);
            }
            for (Schema schema : i2) {
                if (m.containsKey(schema.getTargetNamespace())) continue;
                m.put(schema.getTargetNamespace(), schema);
            }
            this.imports = new Schema[m.size()];
            obj = m.values().toArray();
            for (int i = 0; i < obj.length; ++i) {
                this.imports[i] = (Schema)obj[i];
            }
            URI u1 = s1.getURI();
            URI u2 = s2.getURI();
            this.uri = u1 == null ? u2 : (u2 == null ? u1 : u2.relativize(u1));
            this.prefix = s1.getPrefix() == null || s1.getPrefix().equals("") ? s2.getPrefix() : s1.getPrefix();
        }

        @Override
        public AttributeGroup[] getAttributeGroups() {
            return this.attributeGroups;
        }

        @Override
        public Attribute[] getAttributes() {
            return this.attributes;
        }

        @Override
        public int getBlockDefault() {
            return this.block;
        }

        @Override
        public ComplexType[] getComplexTypes() {
            return this.complexTypes;
        }

        @Override
        public Element[] getElements() {
            return this.elements;
        }

        @Override
        public int getFinalDefault() {
            return this.finaL;
        }

        @Override
        public Group[] getGroups() {
            return this.groups;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Schema[] getImports() {
            return this.imports;
        }

        @Override
        public SimpleType[] getSimpleTypes() {
            return this.simpleTypes;
        }

        @Override
        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean includesURI(URI uri1) {
            if (uri1 == null || this.uri == null) {
                return false;
            }
            return this.uri.equals(uri1);
        }

        @Override
        public boolean isAttributeFormDefault() {
            return this.aForm;
        }

        @Override
        public boolean isElementFormDefault() {
            return this.eForm;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return Collections.emptyMap();
        }
    }
}

