/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.awt.RenderingHints;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.data.util.CommonsConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.xml.impl.DatatypeConverterImpl;

public class XmlConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (String.class.equals((Object)target) ? Date.class.isAssignableFrom(source) || Calendar.class.isAssignableFrom(source) : String.class.equals((Object)source) && (Date.class.isAssignableFrom(target) || Calendar.class.isAssignableFrom(target))) {
            return new XmlConverter();
        }
        return null;
    }

    static class XmlConverter
    implements Converter {
        XmlConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (String.class.equals(target)) {
                return (T)this.convertToString(source);
            }
            return (T)this.convertFromString((String)source, target);
        }

        private Object convertFromString(String source, Class<?> target) {
            Calendar date;
            block15: {
                if (!Calendar.class.equals(target) && !Date.class.isAssignableFrom(target)) {
                    return null;
                }
                try {
                    Converter converter = new CommonsConverterFactory().createConverter(String.class, target, null);
                    if (converter == null) break block15;
                    Object converted = null;
                    try {
                        converted = converter.convert((Object)source, target);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (converted != null) {
                        return converted;
                    }
                }
                catch (Exception converter) {
                    // empty catch block
                }
            }
            try {
                try {
                    date = DatatypeConverterImpl.getInstance().parseDateTime(source);
                }
                catch (Exception e) {
                    date = DatatypeConverterImpl.getInstance().parseDate(source);
                }
            }
            catch (Exception e) {
                date = DatatypeConverterImpl.getInstance().parseTime(source);
            }
            if (Calendar.class.equals(target)) {
                return date;
            }
            if (Date.class.isAssignableFrom(target)) {
                Date time = date.getTime();
                if (java.sql.Date.class.equals(target)) {
                    return new java.sql.Date(time.getTime());
                }
                if (Time.class.equals(target)) {
                    return new Time(time.getTime());
                }
                if (Timestamp.class.equals(target)) {
                    return new Timestamp(time.getTime());
                }
                return time;
            }
            return null;
        }

        private String convertToString(Object unconvertedValue) {
            String textValue = null;
            if (unconvertedValue instanceof Calendar) {
                Calendar cal = (Calendar)unconvertedValue;
                textValue = DatatypeConverterImpl.getInstance().printDateTime(cal);
            } else if (unconvertedValue instanceof java.sql.Date) {
                java.sql.Date sqlDate = (java.sql.Date)unconvertedValue;
                DatatypeConverterImpl converter = DatatypeConverterImpl.getInstance();
                Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
                Calendar cal = Boolean.TRUE.equals(hint) ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(sqlDate.getTime());
                textValue = converter.printDate(cal);
            } else if (unconvertedValue instanceof Date) {
                Date date = (Date)unconvertedValue;
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(date.getTime());
                DatatypeConverterImpl converter = DatatypeConverterImpl.getInstance();
                textValue = unconvertedValue instanceof Time ? converter.printTime(cal) : converter.printDateTime(cal);
            }
            return textValue;
        }
    }
}

