/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.Hints;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterOpsComplexTypes;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeGT;

public class FilterSchema
implements Schema {
    public static final String FILTER_CAP_KEY = "FilterSchema.FilterCapabilities";
    public static final URI NAMESPACE = FilterSchema.makeURI("http://www.opengis.net/ogc");
    private static final FilterSchema instance = new FilterSchema();
    private static Element[] elements = FilterSchema.loadElements();
    private static final ComplexType[] complexTypes = new ComplexType[]{FilterComplexTypes.Comparison_OperatorsType.getInstance(), FilterComplexTypes.Function_NameType.getInstance(), FilterComplexTypes.Function_NamesType.getInstance(), FilterComplexTypes.FunctionsType.getInstance(), FilterComplexTypes.Scalar_CapabilitiesType.getInstance(), FilterComplexTypes.Spatial_CapabilitiesType.getInstance(), FilterComplexTypes.Spatial_OperatorsType.getInstance(), FilterOpsComplexTypes.ComparisonOpsType.getInstance(), FilterOpsComplexTypes.SpatialOpsType.getInstance(), FilterOpsComplexTypes.LogicOpsType.getInstance(), FilterOpsComplexTypes.FilterType.getInstance(), FilterOpsComplexTypes.FeatureIdType.getInstance(), FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), FilterOpsComplexTypes.PropertyIsLikeType.getInstance(), FilterOpsComplexTypes.PropertyIsNullType.getInstance(), FilterOpsComplexTypes.PropertyIsBetweenType.getInstance(), FilterOpsComplexTypes.LowerBoundaryType.getInstance(), FilterOpsComplexTypes.UpperBoundaryType.getInstance(), FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), FilterOpsComplexTypes.BBOXType.getInstance(), FilterOpsComplexTypes.DistanceBufferType.getInstance(), FilterOpsComplexTypes.DistanceType.getInstance(), FilterOpsComplexTypes.BinaryLogicOpType.getInstance(), FilterOpsComplexTypes.UnaryLogicOpType.getInstance(), FilterComplexTypes.ExpressionType.getInstance(), FilterComplexTypes.BinaryOperatorType.getInstance(), FilterComplexTypes.FunctionType.getInstance(), FilterComplexTypes.LiteralType.getInstance(), FilterComplexTypes.PropertyNameType.getInstance(), FilterComplexTypes.ServiceExceptionType.getInstance()};

    static FilterFactory filterFactory(Map map) {
        Hints hints = null;
        if (map instanceof Hints) {
            Hints hints1;
            hints = hints1 = (Hints)map;
        }
        return CommonFactoryFinder.getFilterFactory(hints);
    }

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static FilterSchema getInstance() {
        return instance;
    }

    private static Element[] loadElements() {
        FilterElement comparisonOps = new FilterElement("comparisonOps", FilterOpsComplexTypes.ComparisonOpsType.getInstance()){

            @Override
            public boolean isAbstract() {
                return true;
            }
        };
        FilterElement spatialOps = new FilterElement("spatialOps", FilterOpsComplexTypes.SpatialOpsType.getInstance()){

            @Override
            public boolean isAbstract() {
                return true;
            }
        };
        FilterElement logicOps = new FilterElement("logicOps", FilterOpsComplexTypes.LogicOpsType.getInstance()){

            @Override
            public boolean isAbstract() {
                return true;
            }
        };
        FilterElement expression = new FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()){

            @Override
            public boolean isAbstract() {
                return true;
            }
        };
        elements = new Element[]{new FilterElement("Filter_Capabilities", FilterComplexTypes.Filter_CapabilitiesType.getInstance()), new FilterElement("FeatureId", FilterOpsComplexTypes.FeatureIdType.getInstance(), comparisonOps), new FilterElement("Filter", FilterOpsComplexTypes.FilterType.getInstance(), comparisonOps), comparisonOps, new FilterElement("PropertyIsEqualTo", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsNotEqualTo", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsLessThan", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsGreaterThan", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsLessThanOrEqualTo", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsGreaterThanOrEqualTo", FilterOpsComplexTypes.BinaryComparisonOpType.getInstance(), comparisonOps), new FilterElement("PropertyIsLike", FilterOpsComplexTypes.PropertyIsLikeType.getInstance(), comparisonOps), new FilterElement("PropertyIsNull", FilterOpsComplexTypes.PropertyIsNullType.getInstance(), comparisonOps), new FilterElement("PropertyIsBetween", FilterOpsComplexTypes.PropertyIsBetweenType.getInstance(), comparisonOps), spatialOps, new FilterElement("Equals", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Disjoint", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Touches", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Within", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Overlaps", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Crosses", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Intersects", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("Contains", FilterOpsComplexTypes.BinarySpatialOpType.getInstance(), spatialOps), new FilterElement("DWithin", FilterOpsComplexTypes.DistanceBufferType.getInstance(), spatialOps), new FilterElement("Beyond", FilterOpsComplexTypes.DistanceBufferType.getInstance(), spatialOps), new FilterElement("BBOX", FilterOpsComplexTypes.BBOXType.getInstance(), spatialOps), logicOps, new FilterElement("And", FilterOpsComplexTypes.BinaryLogicOpType.getInstance(), logicOps), new FilterElement("Or", FilterOpsComplexTypes.BinaryLogicOpType.getInstance(), logicOps), new FilterElement("Not", FilterOpsComplexTypes.UnaryLogicOpType.getInstance(), logicOps), expression, new FilterElement("Add", FilterComplexTypes.BinaryOperatorType.getInstance(), expression), new FilterElement("Sub", FilterComplexTypes.BinaryOperatorType.getInstance(), expression), new FilterElement("Mul", FilterComplexTypes.BinaryOperatorType.getInstance(), expression), new FilterElement("Div", FilterComplexTypes.BinaryOperatorType.getInstance(), expression), new FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance(), expression), new FilterElement("Function", FilterComplexTypes.FunctionType.getInstance(), expression), new FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance(), expression), new FilterElement("ServiceExceptionReport", FilterComplexTypes.ServiceExceptionReportType.getInstance())};
        return elements;
    }

    @Override
    public AttributeGroup[] getAttributeGroups() {
        return null;
    }

    @Override
    public Attribute[] getAttributes() {
        return null;
    }

    @Override
    public int getBlockDefault() {
        return 0;
    }

    @Override
    public ComplexType[] getComplexTypes() {
        return complexTypes;
    }

    @Override
    public Element[] getElements() {
        return elements;
    }

    @Override
    public int getFinalDefault() {
        return 0;
    }

    @Override
    public Group[] getGroups() {
        return null;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public Schema[] getImports() {
        return new Schema[]{GMLSchema.getInstance()};
    }

    @Override
    public URI getURI() {
        return NAMESPACE;
    }

    @Override
    public String getPrefix() {
        return "ogc";
    }

    @Override
    public SimpleType[] getSimpleTypes() {
        return null;
    }

    @Override
    public URI getTargetNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public boolean includesURI(URI uri) {
        return true;
    }

    @Override
    public boolean isAttributeFormDefault() {
        return false;
    }

    @Override
    public boolean isElementFormDefault() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public static class FilterElement
    implements Element {
        private String name;
        private Type type;
        private Element substitutionGroup;

        public FilterElement(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public FilterElement(String name, Type type, Element substitutionGroup) {
            this.name = name;
            this.type = type;
            this.substitutionGroup = substitutionGroup;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public int getBlock() {
            return 0;
        }

        @Override
        public String getDefault() {
            return null;
        }

        @Override
        public int getFinal() {
            return 0;
        }

        @Override
        public String getFixed() {
            return null;
        }

        @Override
        public boolean isForm() {
            return false;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public int getMaxOccurs() {
            return 1;
        }

        @Override
        public int getMinOccurs() {
            return 1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public URI getNamespace() {
            return NAMESPACE;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        @Override
        public Element getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getGrouping() {
            return 1;
        }

        @Override
        public Element findChildElement(String name1) {
            return this.getName() != null && this.getName().equals(name1) ? this : null;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            return this.getName() != null && this.getName().equals(localName) && this.getNamespace().equals(namespaceURI) ? this : null;
        }
    }

    static abstract class FilterComplexType
    implements ComplexType {
        FilterComplexType() {
        }

        @Override
        public Type getParent() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public int getBlock() {
            return 0;
        }

        @Override
        public int getFinal() {
            return 0;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public boolean isMixed() {
            return false;
        }

        @Override
        public boolean isDerived() {
            return false;
        }

        @Override
        public boolean cache(Element element, Map<String, Object> hints) {
            return true;
        }

        @Override
        public URI getNamespace() {
            return NAMESPACE;
        }

        @Override
        public Element findChildElement(String name) {
            return this.getChild() == null ? null : this.getChild().findChildElement(name);
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException(element.toString() + " encode value " + String.valueOf(value));
        }

        public String toString() {
            return this.getName();
        }
    }

    static class FilterAttribute
    extends AttributeGT {
        public FilterAttribute(String name, SimpleType type) {
            super(null, name, NAMESPACE, type, 0, null, null, false);
        }

        public FilterAttribute(String name, SimpleType type, int use) {
            super(null, name, NAMESPACE, type, use, null, null, false);
        }

        public FilterAttribute(String name, SimpleType type, int use, String defaulT, String fixed, boolean form) {
            super(null, name, NAMESPACE, type, use, defaulT, fixed, form);
        }
    }
}

