/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.util.Set;
import javax.xml.transform.TransformerException;
import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class FilterTransformer
extends TransformerBase {
    private static String defaultNamespace = "http://www.opengis.net/ogc";

    public String transform(Filter f) throws TransformerException {
        return super.transform(f);
    }

    @Override
    public Translator createTranslator(ContentHandler handler) {
        return new FilterTranslator(handler);
    }

    public static class FilterTranslator
    extends TransformerBase.TranslatorSupport
    implements FilterVisitor,
    ExpressionVisitor {
        GeometryTransformer.GeometryTranslator geometryEncoder;

        public FilterTranslator(ContentHandler handler) {
            super(handler, "ogc", defaultNamespace);
            this.geometryEncoder = new GeometryTransformer.GeometryTranslator(handler);
            this.addNamespaceDeclarations(this.geometryEncoder);
        }

        public Object visit(ExcludeFilter filter, Object extraData) {
            return extraData;
        }

        public Object visit(IncludeFilter filter, Object extraData) {
            return extraData;
        }

        public Object visit(And filter, Object extraData) {
            this.start("And");
            for (Filter child : filter.getChildren()) {
                child.accept((FilterVisitor)this, extraData);
            }
            this.end("And");
            return extraData;
        }

        public Object visit(Id filter, Object extraData) {
            Set fids = filter.getIdentifiers();
            for (Identifier fid : fids) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute(null, "fid", "fid", null, fid.toString());
                this.element("FeatureId", null, atts);
            }
            return extraData;
        }

        public Object visit(Not filter, Object extraData) {
            this.start("Not");
            filter.getFilter().accept((FilterVisitor)this, extraData);
            this.end("Not");
            return extraData;
        }

        public Object visit(Or filter, Object extraData) {
            this.start("Or");
            for (Filter child : filter.getChildren()) {
                child.accept((FilterVisitor)this, extraData);
            }
            this.end("Or");
            return extraData;
        }

        public Object visit(PropertyIsBetween filter, Object extraData) {
            Expression left = filter.getLowerBoundary();
            Expression mid = filter.getExpression();
            Expression right = filter.getUpperBoundary();
            String type = "PropertyIsBetween";
            this.start(type);
            mid.accept((ExpressionVisitor)this, extraData);
            this.start("LowerBoundary");
            left.accept((ExpressionVisitor)this, extraData);
            this.end("LowerBoundary");
            this.start("UpperBoundary");
            right.accept((ExpressionVisitor)this, extraData);
            this.end("UpperBoundary");
            this.end(type);
            return extraData;
        }

        public Object visit(PropertyIsEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsEqualTo";
            this.start("PropertyIsEqualTo");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsEqualTo");
            return extraData;
        }

        public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsNotEqualTo";
            this.start("PropertyIsNotEqualTo");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsNotEqualTo");
            return extraData;
        }

        public Object visit(PropertyIsGreaterThan filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsGreaterThan";
            this.start("PropertyIsGreaterThan");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsGreaterThan");
            return extraData;
        }

        public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsGreaterThanOrEqualTo";
            this.start("PropertyIsGreaterThanOrEqualTo");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsGreaterThanOrEqualTo");
            return extraData;
        }

        public Object visit(PropertyIsLessThan filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsLessThan";
            this.start("PropertyIsLessThan");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsLessThan");
            return extraData;
        }

        public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsLessThanOrEqualTo";
            this.start("PropertyIsLessThanOrEqualTo");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("PropertyIsLessThanOrEqualTo");
            return extraData;
        }

        public Object visit(PropertyIsLike filter, Object extraData) {
            String wcm = filter.getWildCard();
            String wcs = filter.getSingleChar();
            String esc = filter.getEscape();
            Expression expression = filter.getExpression();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "wildCard", "wildCard", "", wcm);
            atts.addAttribute("", "singleChar", "singleChar", "", wcs);
            atts.addAttribute("", "escape", "escape", "", esc);
            this.start("PropertyIsLike", atts);
            expression.accept((ExpressionVisitor)this, extraData);
            this.element("Literal", filter.getLiteral());
            this.end("PropertyIsLike");
            return extraData;
        }

        public Object visit(PropertyIsNull filter, Object extraData) {
            Expression expr = filter.getExpression();
            String type = "PropertyIsNull";
            this.start(type);
            expr.accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(PropertyIsNil filter, Object extraData) {
            Expression expr = filter.getExpression();
            AttributesImpl atts = new AttributesImpl();
            if (filter.getNilReason() != null) {
                atts.addAttribute("", "nilReason", "nilReason", "", filter.getNilReason().toString());
            }
            String type = "PropertyIsNil";
            this.start(type, atts);
            expr.accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(BBOX filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "BBOX";
            this.start("BBOX");
            left.accept((ExpressionVisitor)this, extraData);
            if (right instanceof Literal) {
                Literal literal = (Literal)right;
                Envelope bbox = (Envelope)literal.evaluate(null, Envelope.class);
                if (bbox != null) {
                    this.geometryEncoder.encode(bbox);
                } else {
                    right.accept((ExpressionVisitor)this, extraData);
                }
            } else {
                right.accept((ExpressionVisitor)this, extraData);
            }
            this.end("BBOX");
            return extraData;
        }

        public Object visit(Beyond filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Beyond";
            this.start("Beyond");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.element("Distance", String.valueOf(filter.getDistance()));
            this.element("DistanceUnits", String.valueOf(filter.getDistanceUnits()));
            this.end("Beyond");
            return extraData;
        }

        public Object visit(Contains filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Contains";
            this.start("Contains");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Contains");
            return extraData;
        }

        public Object visit(Crosses filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Crosses";
            this.start("Crosses");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Crosses");
            return extraData;
        }

        public Object visit(Disjoint filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Disjoint";
            this.start("Disjoint");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Disjoint");
            return extraData;
        }

        public Object visit(DWithin filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "DWithin";
            this.start("DWithin");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.element("Distance", String.valueOf(filter.getDistance()));
            this.element("DistanceUnits", String.valueOf(filter.getDistanceUnits()));
            this.end("DWithin");
            return extraData;
        }

        public Object visit(Equals filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Equals";
            this.start("Equals");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Equals");
            return extraData;
        }

        public Object visit(Intersects filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Intersects";
            this.start("Intersects");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Intersects");
            return extraData;
        }

        public Object visit(Overlaps filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Overlaps";
            this.start("Overlaps");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Overlaps");
            return extraData;
        }

        public Object visit(Touches filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Touches";
            this.start("Touches");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Touches");
            return extraData;
        }

        public Object visit(Within filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Within";
            this.start("Within");
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end("Within");
            return extraData;
        }

        public Object visitNullFilter(Object extraData) {
            return extraData;
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof Filter) {
                Filter filter = (Filter)o;
                filter.accept((FilterVisitor)this, null);
            } else if (o instanceof Expression) {
                Expression expression = (Expression)o;
                expression.accept((ExpressionVisitor)this, null);
            } else {
                throw new IllegalArgumentException("Cannot encode " + (o == null ? "null" : o.getClass().getName()) + " should be Filter or Expression");
            }
        }

        public Object visit(NilExpression expression, Object extraData) {
            this.element("Literal", "");
            return extraData;
        }

        public Object visit(Add expression, Object extraData) {
            String type = "Add";
            this.start(type);
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(Divide expression, Object extraData) {
            String type = "Div";
            this.start(type);
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(Function expression, Object extraData) {
            String type = "Function";
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", expression.getName());
            this.start(type, atts);
            for (Expression parameter : expression.getParameters()) {
                parameter.accept((ExpressionVisitor)this, extraData);
            }
            this.end(type);
            return extraData;
        }

        public Object visit(Literal expression, Object extraData) {
            Object value = expression.getValue();
            if (value == null) {
                this.element("Literal", "");
            } else if (value instanceof Geometry) {
                Geometry geometry = (Geometry)value;
                this.geometryEncoder.encode(geometry);
            } else {
                String txt = (String)expression.evaluate(null, String.class);
                if (txt == null) {
                    txt = value.toString();
                }
                this.element("Literal", txt);
            }
            return extraData;
        }

        public Object visit(Multiply expression, Object extraData) {
            String type = "Mul";
            this.start(type);
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(PropertyName expression, Object extraData) {
            this.element("PropertyName", expression.getPropertyName());
            return extraData;
        }

        public Object visit(Subtract expression, Object extraData) {
            String type = "Sub";
            this.start(type);
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return extraData;
        }

        public Object visit(After after, Object extraData) {
            return this.visit((BinaryTemporalOperator)after, "After", extraData);
        }

        public Object visit(AnyInteracts anyInteracts, Object extraData) {
            return this.visit((BinaryTemporalOperator)anyInteracts, "AnyInteracts", extraData);
        }

        public Object visit(Before before, Object extraData) {
            return this.visit((BinaryTemporalOperator)before, "Before", extraData);
        }

        public Object visit(Begins begins, Object extraData) {
            return this.visit((BinaryTemporalOperator)begins, "Begins", extraData);
        }

        public Object visit(BegunBy begunBy, Object extraData) {
            return this.visit((BinaryTemporalOperator)begunBy, "BegunBy", extraData);
        }

        public Object visit(During during, Object extraData) {
            return this.visit((BinaryTemporalOperator)during, "During", extraData);
        }

        public Object visit(EndedBy endedBy, Object extraData) {
            return this.visit((BinaryTemporalOperator)endedBy, "EndedBy", extraData);
        }

        public Object visit(Ends ends, Object extraData) {
            return this.visit((BinaryTemporalOperator)ends, "Ends", extraData);
        }

        public Object visit(Meets meets, Object extraData) {
            return this.visit((BinaryTemporalOperator)meets, "Meets", extraData);
        }

        public Object visit(MetBy metBy, Object extraData) {
            return this.visit((BinaryTemporalOperator)metBy, "MetBy", extraData);
        }

        public Object visit(OverlappedBy overlappedBy, Object extraData) {
            return this.visit((BinaryTemporalOperator)overlappedBy, "OverlappedBy", extraData);
        }

        public Object visit(TContains contains, Object extraData) {
            return this.visit((BinaryTemporalOperator)contains, "TContains", extraData);
        }

        public Object visit(TEquals equals, Object extraData) {
            return this.visit((BinaryTemporalOperator)equals, "TEquals", extraData);
        }

        public Object visit(TOverlaps contains, Object extraData) {
            return this.visit((BinaryTemporalOperator)contains, "TOverlaps", extraData);
        }

        protected Object visit(BinaryTemporalOperator filter, String name, Object data) {
            this.start(name);
            filter.getExpression1().accept((ExpressionVisitor)this, data);
            filter.getExpression2().accept((ExpressionVisitor)this, data);
            this.end(name);
            return data;
        }
    }
}

