/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.util.List;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.xml.gml.ChoiceAttributeTypeImpl;
import org.geotools.xml.gml.ChoiceGeometryType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ChoiceGeometryTypeImpl
extends ChoiceAttributeTypeImpl
implements ChoiceGeometryType,
GeometryType {
    private CoordinateReferenceSystem crs;

    public ChoiceGeometryTypeImpl(Name name, Class[] types, Class defaultType, boolean nillable, int min, int max, Object defaultValue, CoordinateReferenceSystem crs, List<Filter> filter) {
        super(name, types, defaultType, nillable, min, max, defaultValue, filter);
        this.crs = crs;
    }

    @Override
    public Object convert(Object obj) {
        GeometryFactory fac = new GeometryFactory();
        if (this.getBinding() == MultiPolygon.class && obj instanceof Polygon) {
            Polygon polygon = (Polygon)obj;
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        if (this.getBinding() == MultiPoint.class && obj instanceof Point) {
            Point point = (Point)obj;
            return fac.createMultiPoint(new Point[]{point});
        }
        if (this.getBinding() == MultiLineString.class && obj instanceof LineString) {
            LineString string = (LineString)obj;
            return fac.createMultiLineString(new LineString[]{string});
        }
        if (this.getBinding() == GeometryCollection.class && obj instanceof Geometry) {
            Geometry geometry = (Geometry)obj;
            return fac.createGeometryCollection(new Geometry[]{geometry});
        }
        return obj;
    }

    public GeometryType getType() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }
}

